/*
 * Decompiled with CFR 0.152.
 */
package joptsimple.internal;

import java.util.ArrayList;
import java.util.List;
import joptsimple.internal.Columns;
import joptsimple.internal.Row;
import joptsimple.internal.Strings;

public class Rows {
    private final int overallWidth;
    private final int columnSeparatorWidth;
    private final List<Row> rows = new ArrayList<Row>();
    private int widthOfWidestOption;
    private int widthOfWidestDescription;

    public Rows(int overallWidth, int columnSeparatorWidth) {
        this.overallWidth = overallWidth;
        this.columnSeparatorWidth = columnSeparatorWidth;
    }

    public void add(String option2, String description) {
        this.add(new Row(option2, description));
    }

    private void add(Row row) {
        this.rows.add(row);
        this.widthOfWidestOption = Math.max(this.widthOfWidestOption, row.option.length());
        this.widthOfWidestDescription = Math.max(this.widthOfWidestDescription, row.description.length());
    }

    private void reset() {
        this.rows.clear();
        this.widthOfWidestOption = 0;
        this.widthOfWidestDescription = 0;
    }

    public void fitToWidth() {
        Columns columns = new Columns(this.optionWidth(), this.descriptionWidth());
        ArrayList<Row> fitted = new ArrayList<Row>();
        for (Row each : this.rows) {
            fitted.addAll(columns.fit(each));
        }
        this.reset();
        for (Row each : fitted) {
            this.add(each);
        }
    }

    public String render() {
        StringBuilder buffer2 = new StringBuilder();
        for (Row each : this.rows) {
            this.pad(buffer2, each.option, this.optionWidth()).append(Strings.repeat(' ', this.columnSeparatorWidth));
            this.pad(buffer2, each.description, this.descriptionWidth()).append(Strings.LINE_SEPARATOR);
        }
        return buffer2.toString();
    }

    private int optionWidth() {
        return Math.min((this.overallWidth - this.columnSeparatorWidth) / 2, this.widthOfWidestOption);
    }

    private int descriptionWidth() {
        return Math.min((this.overallWidth - this.columnSeparatorWidth) / 2, this.widthOfWidestDescription);
    }

    private StringBuilder pad(StringBuilder buffer2, String s, int length2) {
        buffer2.append(s).append(Strings.repeat(' ', length2 - s.length()));
        return buffer2;
    }
}

