/*
 * Decompiled with CFR 0.152.
 */
package coursier.shaded.org.jsoup.parser;

import coursier.shaded.org.jsoup.helper.Validate;
import coursier.shaded.org.jsoup.nodes.Attributes;
import coursier.shaded.org.jsoup.nodes.Document;
import coursier.shaded.org.jsoup.nodes.Element;
import coursier.shaded.org.jsoup.parser.CharacterReader;
import coursier.shaded.org.jsoup.parser.ParseErrorList;
import coursier.shaded.org.jsoup.parser.ParseSettings;
import coursier.shaded.org.jsoup.parser.Token;
import coursier.shaded.org.jsoup.parser.Tokeniser;
import java.util.ArrayList;

abstract class TreeBuilder {
    CharacterReader reader;
    Tokeniser tokeniser;
    protected Document doc;
    protected ArrayList<Element> stack;
    protected String baseUri;
    protected Token currentToken;
    protected ParseErrorList errors;
    protected ParseSettings settings;
    private Token.StartTag start = new Token.StartTag();
    private Token.EndTag end = new Token.EndTag();

    TreeBuilder() {
    }

    abstract ParseSettings defaultSettings();

    protected void initialiseParse(String input, String baseUri, ParseErrorList errors2, ParseSettings settings) {
        Validate.notNull(input, "String input must not be null");
        Validate.notNull(baseUri, "BaseURI must not be null");
        this.doc = new Document(baseUri);
        this.settings = settings;
        this.reader = new CharacterReader(input);
        this.errors = errors2;
        this.tokeniser = new Tokeniser(this.reader, errors2);
        this.stack = new ArrayList(32);
        this.baseUri = baseUri;
    }

    Document parse(String input, String baseUri, ParseErrorList errors2, ParseSettings settings) {
        this.initialiseParse(input, baseUri, errors2, settings);
        this.runParser();
        return this.doc;
    }

    protected void runParser() {
        Token token;
        do {
            token = this.tokeniser.read();
            this.process(token);
            token.reset();
        } while (token.type != Token.TokenType.EOF);
    }

    protected abstract boolean process(Token var1);

    protected boolean processStartTag(String name) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().name(name));
        }
        return this.process(this.start.reset().name(name));
    }

    public boolean processStartTag(String name, Attributes attrs) {
        if (this.currentToken == this.start) {
            return this.process(new Token.StartTag().nameAttr(name, attrs));
        }
        this.start.reset();
        this.start.nameAttr(name, attrs);
        return this.process(this.start);
    }

    protected boolean processEndTag(String name) {
        if (this.currentToken == this.end) {
            return this.process(new Token.EndTag().name(name));
        }
        return this.process(this.end.reset().name(name));
    }

    protected Element currentElement() {
        int size2 = this.stack.size();
        return size2 > 0 ? this.stack.get(size2 - 1) : null;
    }
}

