<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 -->

### 2.0.0

<details>	
  <summary><mark>Release notes</mark></summary>

### Seata-go 2.0.0

Seata-go 2.0.0 Released.

Seata-go is an easy-to-use, high-performance, open source distributed transaction solution.

The version is updated as follows:

### feature：

- [[#659](https://github.com/apache/incubator-seata-go/pull/659)] support compress for AT undo log
- [[#574](https://github.com/apache/incubator-seata-go/pull/574)] support file and nacos service registry
- [[#584](https://github.com/apache/incubator-seata-go/pull/584)] support the ConsistentHash load balancing strategy in the remoting module
- [[#585](https://github.com/apache/incubator-seata-go/pull/585)] support the LeastActive load balancing strategy in the remoting module
- [[#605](https://github.com/apache/incubator-seata-go/pull/605)] support the discovery service of Etcd
- [[#622](https://github.com/apache/incubator-seata-go/pull/622)] add round robin strategy of remote call
- [[#691](https://github.com/apache/incubator-seata-go/pull/691)] support protobuf undo log parser
- [[#738](https://github.com/apache/incubator-seata-go/pull/738)] remove session when send heart beat message failed
- [[#739](https://github.com/apache/incubator-seata-go/pull/739)] support automatic refresh functionality for table meta cache

### bugfix：

- [[#540](https://github.com/apache/incubator-seata-go/pull/540)] fix init XA panic bug
- [[#590](https://github.com/apache/incubator-seata-go/pull/590)] fix some repo error
- [[#595](https://github.com/apache/incubator-seata-go/pull/595)] check the response error is nil for commit or rollback
- [[#607](https://github.com/apache/incubator-seata-go/pull/607)] fix the bug of jackson serialize
- [[#665](https://github.com/apache/incubator-seata-go/pull/665)] reclaim the heartbeat response message to avoid memory leakage of GettyRemoting.future
- [[#672](https://github.com/apache/incubator-seata-go/pull/672)] fix AT rollback bug
- [[#674](https://github.com/apache/incubator-seata-go/pull/674)] fix XA rollback bug
- [[#690](https://github.com/apache/incubator-seata-go/pull/690)] fix AT undo log jackson parser not found bug
- [[#701](https://github.com/apache/incubator-seata-go/pull/701)] fix the InsertOnDuplicateUpdate is an issue with bypassing modifying the primary key
- [[#717](https://github.com/apache/incubator-seata-go/pull/717)] support XA report state to TC
- [[#724](https://github.com/apache/incubator-seata-go/pull/724)] support ParenthesesExpr for SQL parser
- [[#736](https://github.com/apache/incubator-seata-go/pull/736)] fix SQL statement not closed's bug
- [[#743](https://github.com/apache/incubator-seata-go/pull/743)] fix bug of gomonkey
- [[#749](https://github.com/apache/incubator-seata-go/pull/749)] fix bug of heart beat


### optimize:

- [[#576](https://github.com/apache/incubator-seata-go/pull/576)]  use mirromutth/mysql-action instead of icomponent/mysql-action
- [[#594](https://github.com/apache/incubator-seata-go/pull/594)] optimize the log of branch commit procesor
- [[#621](https://github.com/apache/incubator-seata-go/pull/621)] add codeql for ci
- [[#631](https://github.com/apache/incubator-seata-go/pull/631)] upgrade crypto version from 0.9.0 to 0.17.0
- [[#652](https://github.com/apache/incubator-seata-go/pull/652)] upgrade gRPC version from 1.51.0 ro 1.56.3
- [[#667](https://github.com/apache/incubator-seata-go/pull/667)] change mailbox of issues and pull requests from dev to notifications
- [[#678](https://github.com/apache/incubator-seata-go/pull/678)] rename module name to seata.apache.org/seata-go
- [[#679](https://github.com/apache/incubator-seata-go/pull/679)] upgrade getty version from 1.4.9 to 1.4.10
- [[#714](https://github.com/apache/incubator-seata-go/pull/714)] optimize the speed of build lock key
- [[#719](https://github.com/apache/incubator-seata-go/pull/719)] only save insertd filed when execute insert SQL in AT
- [[#721](https://github.com/apache/incubator-seata-go/pull/721)] fix the issue where the translation bot is not working
- [[#758](https://github.com/apache/incubator-seata-go/pull/758)] remove unusen files

### test:

- [[#570](https://github.com/apache/incubator-seata-go/pull/570)] add collection unit test
- [[#571](https://github.com/apache/incubator-seata-go/pull/571)] add convert unit test
- [[#572](https://github.com/apache/incubator-seata-go/pull/572)] add reflectx unit test
- [[#5835f0](https://github.com/apache/incubator-seata-go/commit/5835f09ecfd6edeb04c2961163bc4460f578e942)] add random loadbalance unit test
- [[#599](https://github.com/apache/incubator-seata-go/pull/599)] add xid loadbalance unit test


### doc:
- [[#614](https://github.com/apache/incubator-seata-go/pull/614)] upgrade the unknown license dependency
- [[#632](https://github.com/apache/incubator-seata-go/pull/632)] add ASF basic config
- [[#633](https://github.com/apache/incubator-seata-go/pull/633)] optimize ASF basic config to remove th context check
- [[#644](https://github.com/apache/incubator-seata-go/pull/644)] optimize readme file
- [[#686](https://github.com/apache/incubator-seata-go/pull/686)] add more linter in ci
- [[#737](https://github.com/apache/incubator-seata-go/pull/737)] modify the readme file and update the currently completed work
- [[#756](https://github.com/apache/incubator-seata-go/pull/756)] update license checker
- [[#797](https://github.com/apache/incubator-seata-go/pull/797)] add ASF header to some files


### contributors:

Thanks to these contributors for their code commits. Please report an unintended omission.

- [luky116](https://github.com/luky116)
- [Code-Fight](https://github.com/Code-Fight)
- [wt-better](https://github.com/wt-better)
- [luweiqianyi](https://github.com/luweiqianyi)
- [wang1309](https://github.com/wang1309)
- [576470954](https://github.com/576470954)
- [No-SilverBullet](https://github.com/No-SilverBullet)
- [solisamicus](https://github.com/solisamicus)
- [marsevilspirit](https://github.com/marsevilspirit)
- [lxfeng1997](https://github.com/lxfeng1997)
- [AlexStocks](https://github.com/AlexStocks)
- [smiletrl](https://github.com/smiletrl)
- [ptyin](https://github.com/ptyin)
- [yizhibian](https://github.com/yizhibian)
- [oldmee](https://github.com/oldmee)
- [air-3](https://github.com/air-3)
- [slievrly](https://github.com/slievrly)
- [xjlgod](https://github.com/xjlgod)
- [baerwang](https://github.com/baerwang)
- [xyombo](https://github.com/xyombo)
- [testwill](https://github.com/testwill)
- [jasondeng1997](https://github.com/jasondeng1997)
- [jsbxyyx](https://github.com/jsbxyyx)
- [iSuperCoder](https://github.com/iSuperCoder)
- [georgehao](https://github.com/georgehao)
- [liuyuecai](https://github.com/liuyuecai)
- [106umao](https://github.com/106umao)
- [FinnTew](https://github.com/FinnTew)
- [funky-eyes](https://github.com/funky-eyes)
- [tanzegen](https://github.com/tanzegen)
- [lovepoem](https://github.com/lovepoem)
- [YvCeung](https://github.com/YvCeung)


Also, we receive many valuable issues, questions and advices from our community. Thanks all.

</detail>