/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.v0;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import org.apache.seata.core.exception.DecodeException;
import org.apache.seata.core.protocol.HeartbeatMessage;
import org.apache.seata.core.protocol.RpcMessage;
import org.apache.seata.core.rpc.netty.ProtocolDecoder;
import org.apache.seata.core.rpc.netty.v0.ProtocolConstantsV0;
import org.apache.seata.core.rpc.netty.v0.ProtocolRpcMessageV0;
import org.apache.seata.core.serializer.Serializer;
import org.apache.seata.core.serializer.SerializerServiceLoader;
import org.apache.seata.core.serializer.SerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtocolDecoderV0
extends LengthFieldBasedFrameDecoder
implements ProtocolDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProtocolDecoderV0.class);

    public ProtocolDecoderV0() {
        super(0x800000, 3, 4, -7, 0);
    }

    @Override
    public RpcMessage decodeFrame(ByteBuf in) {
        ProtocolRpcMessageV0 rpcMessage = new ProtocolRpcMessageV0();
        if (in.readableBytes() < ProtocolConstantsV0.HEAD_LENGTH) {
            throw new IllegalArgumentException("Nothing to decode.");
        }
        in.markReaderIndex();
        short protocol = in.readShort();
        short flag = in.readShort();
        boolean isHeartbeat = (0x20 & flag) > 0;
        boolean isRequest = (0x80 & flag) > 0;
        boolean isSeataCodec = (0x10 & flag) > 0;
        rpcMessage.setSeataCodec(isSeataCodec);
        short bodyLength = 0;
        short typeCode = 0;
        if (!isSeataCodec) {
            bodyLength = in.readShort();
        } else {
            typeCode = in.readShort();
        }
        long msgId = in.readLong();
        rpcMessage.setId(msgId);
        if (isHeartbeat) {
            rpcMessage.setAsync(true);
            rpcMessage.setHeartbeat(isHeartbeat);
            rpcMessage.setRequest(isRequest);
            if (isRequest) {
                rpcMessage.setBody(HeartbeatMessage.PING);
            } else {
                rpcMessage.setBody(HeartbeatMessage.PONG);
            }
            return rpcMessage.protocolMsg2RpcMsg();
        }
        if (bodyLength > 0 && in.readableBytes() < bodyLength) {
            in.resetReaderIndex();
            throw new IllegalArgumentException("readableBytes < bodyLength");
        }
        rpcMessage.setAsync((0x40 & flag) > 0);
        rpcMessage.setHeartbeat(false);
        rpcMessage.setRequest(isRequest);
        try {
            int length = in.readableBytes();
            byte[] bs = new byte[length];
            in.readBytes(bs);
            byte[] bs2 = new byte[2 + length];
            bs2[0] = (byte)(0xFF & typeCode >> 8);
            bs2[1] = (byte)(0xFF & typeCode);
            System.arraycopy(bs, 0, bs2, 2, length);
            byte codecType = isSeataCodec ? SerializerType.SEATA.getCode() : SerializerType.HESSIAN.getCode();
            Serializer serializer = SerializerServiceLoader.load(SerializerType.getByCode(codecType), (byte)0);
            rpcMessage.setBody(serializer.deserialize(bs2));
        }
        catch (Exception e) {
            LOGGER.error("decode error", (Throwable)e);
            throw e;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Receive:" + rpcMessage.getBody() + ", messageId:" + msgId);
        }
        return rpcMessage.protocolMsg2RpcMsg();
    }

    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        try {
            return this.decodeFrame(in);
        }
        catch (Exception exx) {
            LOGGER.error("Decode frame error, cause: {}", (Object)exx.getMessage());
            throw new DecodeException(exx);
        }
    }
}

