/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.rpc.netty.http;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.seata.common.rpc.http.HttpContext;
import org.apache.seata.core.rpc.netty.http.ParamMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterParser.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    private static final String DEFAULT_NONE = "\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n";

    public static ObjectNode convertParamMap(Map<String, List<String>> paramMap) {
        ObjectNode paramNode = OBJECT_MAPPER.createObjectNode();
        for (Map.Entry<String, List<String>> entry : paramMap.entrySet()) {
            List<String> list = entry.getValue();
            if (list == null || list.isEmpty()) continue;
            if (list.size() == 1) {
                paramNode.put(entry.getKey(), list.get(0));
                continue;
            }
            ArrayNode arrayNode = paramNode.putArray(entry.getKey());
            for (String s : list) {
                arrayNode.add(s);
            }
        }
        return paramNode;
    }

    public static Object[] getArgValues(ParamMetaData[] paramMetaDatas, Method handleMethod, ObjectNode paramMap, HttpContext httpContext) throws JsonProcessingException {
        Class<?>[] parameterTypes = handleMethod.getParameterTypes();
        Parameter[] parameters = handleMethod.getParameters();
        return ParameterParser.getParameters(parameterTypes, paramMetaDatas, parameters, paramMap, httpContext);
    }

    private static Object[] getParameters(Class<?>[] parameterTypes, ParamMetaData[] paramMetaDatas, Parameter[] parameters, ObjectNode paramMap, HttpContext httpContext) throws JsonProcessingException {
        int length = parameterTypes.length;
        Object[] ret = new Object[length];
        for (int i = 0; i < length; ++i) {
            ParamMetaData paramMetaData;
            Class<?> parameterType = parameterTypes[i];
            String parameterName = parameters[i].getName();
            Object value = ParameterParser.getArgValue(parameterType, parameterName, paramMetaData = paramMetaDatas[i], paramMap, httpContext);
            if (value != null && !parameterType.isAssignableFrom(value.getClass())) {
                LOGGER.error("[HttpDispatchHandler] not compatible parameter type, expect {}, but {}", parameterType, ret[i].getClass());
                ret[i] = null;
                continue;
            }
            ret[i] = value;
        }
        return ret;
    }

    private static Object getArgValue(Class<?> parameterType, String parameterName, ParamMetaData paramMetaData, ObjectNode paramMap, HttpContext httpContext) {
        JsonNode jsonNode;
        ParamMetaData.ParamConvertType paramConvertType = paramMetaData.getParamConvertType();
        if (HttpContext.class.equals(parameterType)) {
            return httpContext;
        }
        if (ParamMetaData.ParamConvertType.MODEL_ATTRIBUTE.equals((Object)paramConvertType)) {
            JsonNode param = paramMap.get("param");
            return OBJECT_MAPPER.convertValue((Object)param, parameterType);
        }
        if (ParamMetaData.ParamConvertType.REQUEST_BODY.equals((Object)paramConvertType)) {
            JsonNode body2 = paramMap.get("body");
            return OBJECT_MAPPER.convertValue((Object)body2, parameterType);
        }
        if (ParamMetaData.ParamConvertType.REQUEST_PARAM.equals((Object)paramConvertType)) {
            String paramName = paramMetaData.getParamName();
            JsonNode jsonNode2 = Optional.ofNullable(paramMap.get("param")).map(body -> body.get(paramName)).orElse(null);
            if (jsonNode2 != null && !jsonNode2.isNull()) {
                return OBJECT_MAPPER.convertValue((Object)jsonNode2, parameterType);
            }
            String defaultValue = paramMetaData.getDefaultValue();
            if (defaultValue != null && !defaultValue.equals(DEFAULT_NONE)) {
                return OBJECT_MAPPER.convertValue((Object)defaultValue, parameterType);
            }
            if (paramMetaData.isRequired()) {
                throw new IllegalArgumentException("Required request parameter '" + paramName + "' is missing");
            }
            return null;
        }
        JsonNode paramNode = paramMap.get("param");
        if (paramNode != null && (jsonNode = paramNode.get(parameterName)) != null) {
            String value = jsonNode.asText(null);
            return value != null ? OBJECT_MAPPER.convertValue((Object)value, parameterType) : null;
        }
        return null;
    }
}

