/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.task;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.hugegraph.loader.builder.EdgeBuilder;
import org.apache.hugegraph.loader.builder.ElementBuilder;
import org.apache.hugegraph.loader.builder.Record;
import org.apache.hugegraph.loader.builder.VertexBuilder;
import org.apache.hugegraph.loader.exception.ParseException;
import org.apache.hugegraph.loader.executor.LoadContext;
import org.apache.hugegraph.loader.mapping.EdgeMapping;
import org.apache.hugegraph.loader.mapping.ElementMapping;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.VertexMapping;
import org.apache.hugegraph.loader.metrics.LoadMetrics;
import org.apache.hugegraph.loader.reader.line.Line;
import org.apache.hugegraph.structure.GraphElement;
import org.apache.hugegraph.structure.graph.Vertex;
import org.apache.hugegraph.structure.schema.VertexLabel;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public final class ParseTaskBuilder {
    private static final Logger LOG = Log.logger(ParseTaskBuilder.class);
    private final LoadContext context;
    private final InputStruct struct;
    private final List<ElementBuilder> builders;

    public ParseTaskBuilder(LoadContext context, InputStruct struct) {
        this.context = context;
        this.struct = struct;
        this.builders = new ArrayList<ElementBuilder>();
        for (VertexMapping vertexMapping : struct.vertices()) {
            this.builders.add(new VertexBuilder(this.context, struct, vertexMapping));
        }
        for (EdgeMapping edgeMapping : struct.edges()) {
            this.builders.add(new EdgeBuilder(this.context, struct, edgeMapping));
        }
    }

    public InputStruct struct() {
        return this.struct;
    }

    public List<ParseTask> build(List<Line> lines) {
        ArrayList<ParseTask> tasks = new ArrayList<ParseTask>(this.builders.size());
        for (ElementBuilder builder : this.builders) {
            if (builder.mapping().skip()) continue;
            tasks.add(this.buildTask(builder, lines));
        }
        return tasks;
    }

    private ParseTask buildTask(ElementBuilder builder, List<Line> lines) {
        LoadMetrics metrics = this.context.summary().metrics(this.struct);
        int batchSize = this.context.options().batchSize;
        ElementMapping mapping = builder.mapping();
        boolean needRemoveId = builder instanceof VertexBuilder && ((VertexLabel)builder.schemaLabel()).idStrategy().isPrimaryKey();
        return new ParseTask(mapping, () -> {
            ArrayList batches = new ArrayList();
            ArrayList<Record> records = new ArrayList<Record>(batchSize);
            int count = 0;
            for (Line line : lines) {
                try {
                    List elements = builder.build(line.names(), line.values());
                    E.checkState((elements.size() <= batchSize ? 1 : 0) != 0, (String)"The number of columns in a line cannot exceed the size of a batch, but got %s > %s", (Object[])new Object[]{elements.size(), batchSize});
                    if (records.size() + elements.size() > batchSize) {
                        LOG.debug("Create a new batch for {}", (Object)mapping);
                        batches.add(records);
                        records = new ArrayList(batchSize);
                    }
                    for (GraphElement element : elements) {
                        if (needRemoveId) {
                            ((Vertex)element).id(null);
                        }
                        records.add(new Record(line.rawLine(), element));
                        ++count;
                    }
                }
                catch (IllegalArgumentException e) {
                    metrics.increaseParseFailure(mapping);
                    ParseException pe = new ParseException(line.rawLine(), e);
                    this.handleParseFailure(mapping, pe);
                }
            }
            if (!records.isEmpty()) {
                batches.add(records);
            }
            metrics.plusParseSuccess(mapping, count);
            return batches;
        });
    }

    private void handleParseFailure(ElementMapping mapping, ParseException e) {
        LOG.error("Parse {} error", (Object)mapping.type(), (Object)e);
        this.context.occurredError();
        if (this.context.options().testMode) {
            throw e;
        }
        this.context.failureLogger(this.struct).write(e);
    }

    public static class ParseTask
    implements Supplier<List<List<Record>>> {
        private final ElementMapping mapping;
        private final Supplier<List<List<Record>>> supplier;

        public ParseTask(ElementMapping mapping, Supplier<List<List<Record>>> supplier) {
            this.mapping = mapping;
            this.supplier = supplier;
        }

        public ElementMapping mapping() {
            return this.mapping;
        }

        @Override
        public List<List<Record>> get() {
            return this.supplier.get();
        }
    }
}

