/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

@Deprecated
public class FlatFileInputFormat<T>
extends FileInputFormat<Void, RowContainer<T>> {
    public static final String SerializationImplKey = "mapred.input.serialization.implKey";

    protected boolean isSplittable(FileSystem fs, Path filename) {
        return false;
    }

    public RecordReader<Void, RowContainer<T>> getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        reporter.setStatus(split.toString());
        return new FlatFileRecordReader((Configuration)job, (FileSplit)split);
    }

    @Deprecated
    public class FlatFileRecordReader<R>
    implements RecordReader<Void, RowContainer<R>> {
        private final DataInputStream in;
        private final InputStream dcin;
        private final FSDataInputStream fsin;
        private final long end;
        private final Deserializer<R> deserializer;
        private boolean isEOF;
        private final Configuration conf;
        private final Class<R> realRowClass;
        public static final String SerializationContextImplKey = "mapred.input.serialization.context_impl";

        public FlatFileRecordReader(Configuration conf, FileSplit split) throws IOException {
            Path path = split.getPath();
            FileSystem fileSys = path.getFileSystem(conf);
            CompressionCodecFactory compressionCodecs = new CompressionCodecFactory(conf);
            CompressionCodec codec = compressionCodecs.getCodec(path);
            this.conf = conf;
            this.fsin = fileSys.open(path);
            if (codec != null) {
                this.dcin = codec.createInputStream((InputStream)this.fsin);
                this.in = new DataInputStream(this.dcin);
            } else {
                this.dcin = null;
                this.in = this.fsin;
            }
            this.isEOF = false;
            this.end = split.getLength();
            Class sinfoClass = conf.getClass(SerializationContextImplKey, SerializationContextFromConf.class);
            SerializationContext sinfo = (SerializationContext)ReflectionUtils.newInstance((Class)sinfoClass, (Configuration)conf);
            Serialization serialization = sinfo.getSerialization();
            this.realRowClass = sinfo.getRealClass();
            this.deserializer = serialization.getDeserializer(this.realRowClass);
            this.deserializer.open((InputStream)this.in);
        }

        public Void createKey() {
            return null;
        }

        public RowContainer<R> createValue() {
            RowContainer r = new RowContainer();
            r.row = ReflectionUtils.newInstance(this.realRowClass, (Configuration)this.conf);
            return r;
        }

        public synchronized boolean next(Void key, RowContainer<R> value) throws IOException {
            if (this.isEOF || this.in.available() == 0) {
                this.isEOF = true;
                return false;
            }
            try {
                value.row = this.deserializer.deserialize(value.row);
                if (value.row == null) {
                    this.isEOF = true;
                    return false;
                }
                return true;
            }
            catch (EOFException e) {
                this.isEOF = true;
                return false;
            }
        }

        public synchronized float getProgress() throws IOException {
            if (this.end == 0L) {
                return 0.0f;
            }
            return Math.min(1.0f, (float)this.fsin.getPos() / (float)this.end);
        }

        public synchronized long getPos() throws IOException {
            return this.fsin.getPos();
        }

        public synchronized void close() throws IOException {
            this.deserializer.close();
        }
    }

    public static class SerializationContextFromConf<S>
    implements SerializationContext<S> {
        public static final String SerializationSubclassKey = "mapred.input.serialization.subclassKey";
        private Configuration conf;

        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public Class<S> getRealClass() throws IOException {
            return this.conf.getClass(SerializationSubclassKey, null, Object.class);
        }

        @Override
        public Serialization<S> getSerialization() throws IOException {
            Class tClass = this.conf.getClass(FlatFileInputFormat.SerializationImplKey, null, Serialization.class);
            return tClass == null ? null : (Serialization)ReflectionUtils.newInstance((Class)tClass, (Configuration)this.conf);
        }
    }

    public static interface SerializationContext<S>
    extends Configurable {
        public Serialization<S> getSerialization() throws IOException;

        public Class<? extends S> getRealClass() throws IOException;
    }

    public static class RowContainer<T> {
        T row;
    }
}

