/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public abstract class StringGroupScalarLessEqualStringGroupColumnBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final int colNum;
    protected final byte[] value;

    public StringGroupScalarLessEqualStringGroupColumnBase(int colNum, byte[] value, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum = colNum;
        this.value = value;
    }

    public StringGroupScalarLessEqualStringGroupColumnBase() {
        this.colNum = -1;
        this.value = null;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        block13: {
            int[] start;
            int[] length;
            byte[][] vector;
            boolean[] outputIsNull;
            boolean[] inputIsNull;
            int[] sel;
            int n;
            block14: {
                BytesColumnVector inputColVector;
                block12: {
                    n = batch.size;
                    if (n == 0) {
                        return;
                    }
                    if (this.childExpressions != null) {
                        super.evaluateChildren(batch);
                    }
                    inputColVector = (BytesColumnVector)batch.cols[this.colNum];
                    LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
                    sel = batch.selected;
                    inputIsNull = inputColVector.isNull;
                    outputIsNull = outputColVector.isNull;
                    vector = inputColVector.vector;
                    length = inputColVector.length;
                    start = inputColVector.start;
                    long[] outVector = outputColVector.vector;
                    outputColVector.isRepeating = false;
                    if (!inputColVector.noNulls) break block12;
                    if (inputColVector.isRepeating) {
                        outputColVector.isRepeating = true;
                        outputIsNull[0] = false;
                        outVector[0] = StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) <= 0 ? 1L : 0L;
                    } else if (batch.selectedInUse) {
                        for (int j = 0; j != n; ++j) {
                            int i = sel[j];
                            outputIsNull[i] = false;
                            outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) <= 0 ? 1L : 0L;
                        }
                    } else {
                        Arrays.fill(outputIsNull, 0, n, false);
                        for (int i = 0; i != n; ++i) {
                            outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) <= 0 ? 1L : 0L;
                        }
                    }
                    break block13;
                }
                outputColVector.noNulls = false;
                if (!inputColVector.isRepeating) break block14;
                outputColVector.isRepeating = true;
                outputIsNull[0] = inputIsNull[0];
                if (inputIsNull[0]) break block13;
                outVector[0] = StringExpr.compare(this.value, 0, this.value.length, vector[0], start[0], length[0]) <= 0 ? 1L : 0L;
                break block13;
            }
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) <= 0 ? 1L : 0L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    outVector[i] = StringExpr.compare(this.value, 0, this.value.length, vector[i], start[i], length[i]) <= 0 ? 1L : 0L;
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return "val " + StringGroupScalarLessEqualStringGroupColumnBase.displayUtf8Bytes(this.value) + ", " + this.getColumnParamString(1, this.colNum);
    }
}

