/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringLength;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.WritableIntObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.IntWritable;

@Description(name="character_length,char_length", value="_FUNC_(str | binary) - Returns the number of characters in str or binary data", extended="Example:\n  > SELECT _FUNC_('\uc548\ub155\ud558\uc138\uc694') FROM src LIMIT 1;\n  5")
@VectorizedExpressions(value={StringLength.class})
public class GenericUDFCharacterLength
extends GenericUDF {
    private final IntWritable result = new IntWritable();
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.StringConverter stringConverter;
    private transient boolean isInputString;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentLengthException("CHARACTER_LENGTH requires 1 argument, got " + arguments.length);
        }
        if (arguments[0].getCategory() != ObjectInspector.Category.PRIMITIVE) {
            throw new UDFArgumentException("CHARACTER_LENGTH only takes primitive types, got " + this.argumentOI.getTypeName());
        }
        this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        this.stringConverter = new PrimitiveObjectInspectorConverter.StringConverter(this.argumentOI);
        PrimitiveObjectInspector.PrimitiveCategory inputType = this.argumentOI.getPrimitiveCategory();
        WritableIntObjectInspector outputOI = null;
        switch (inputType) {
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                this.isInputString = true;
                break;
            }
            case BINARY: {
                this.isInputString = false;
                break;
            }
            default: {
                throw new UDFArgumentException(" CHARACTER_LENGTH() only takes STRING/CHAR/VARCHAR/BINARY types as first argument, got " + (Object)((Object)inputType));
            }
        }
        outputOI = PrimitiveObjectInspectorFactory.writableIntObjectInspector;
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        String val;
        byte[] data = null;
        if (this.isInputString) {
            val = null;
            if (arguments[0] != null) {
                val = (String)this.stringConverter.convert(arguments[0].get());
            }
            if (val == null) {
                return null;
            }
            data = val.getBytes();
        } else {
            val = null;
            if (arguments[0] != null) {
                val = (BytesWritable)arguments[0].get();
            }
            if (val == null) {
                return null;
            }
            data = val.getBytes();
        }
        int len = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!GenericUDFUtils.isUtfStartByte(data[i])) continue;
            ++len;
        }
        this.result.set(len);
        return this.result;
    }

    @Override
    public String getDisplayString(String[] children) {
        return this.getStandardDisplayString("character_length", children);
    }
}

