/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.serializer.direct.struct;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.Date;
import java.util.UUID;
import org.apache.hugegraph.serializer.direct.util.HugeException;
import org.apache.hugegraph.serializer.direct.util.StringEncoding;
import org.apache.hugegraph.util.CollectionUtil;
import org.apache.hugegraph.util.DateUtil;
import org.apache.hugegraph.util.E;

public final class DataType
extends Enum<DataType> {
    public static final /* enum */ DataType UNKNOWN = new DataType(0, "unknown", Object.class);
    public static final /* enum */ DataType OBJECT = new DataType(1, "object", Object.class);
    public static final /* enum */ DataType BOOLEAN = new DataType(2, "boolean", Boolean.class);
    public static final /* enum */ DataType BYTE = new DataType(3, "byte", Byte.class);
    public static final /* enum */ DataType INT = new DataType(4, "int", Integer.class);
    public static final /* enum */ DataType LONG = new DataType(5, "long", Long.class);
    public static final /* enum */ DataType FLOAT = new DataType(6, "float", Float.class);
    public static final /* enum */ DataType DOUBLE = new DataType(7, "double", Double.class);
    public static final /* enum */ DataType TEXT = new DataType(8, "text", String.class);
    public static final /* enum */ DataType DATE = new DataType(10, "date", Date.class);
    public static final /* enum */ DataType UUID = new DataType(11, "uuid", UUID.class);
    private final byte code;
    private final String name;
    private final Class<?> clazz;
    static Table<Class<?>, Byte, DataType> TABLE;
    private static final /* synthetic */ DataType[] $VALUES;

    public static DataType[] values() {
        return (DataType[])$VALUES.clone();
    }

    public static DataType valueOf(String name) {
        return Enum.valueOf(DataType.class, name);
    }

    static void register(Class<? extends DataType> clazz) {
        Object enums;
        try {
            enums = clazz.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new HugeException("DataType invalid", e);
        }
        for (DataType e : CollectionUtil.toList((Object)enums)) {
            TABLE.put(clazz, (Object)e.code(), (Object)e);
        }
    }

    static <T extends DataType> T fromCode(Class<T> clazz, byte code) {
        DataType value = (DataType)((Object)TABLE.get(clazz, (Object)code));
        if (value == null) {
            E.checkArgument((boolean)false, (String)"Can't construct %s from code %s", (Object[])new Object[]{clazz.getSimpleName(), code});
        }
        return (T)((Object)value);
    }

    private DataType(int code, String name, Class<?> clazz) {
        assert (code < 256);
        this.code = (byte)code;
        this.name = name;
        this.clazz = clazz;
    }

    public byte code() {
        return this.code;
    }

    public String string() {
        return this.name;
    }

    public Class<?> clazz() {
        return this.clazz;
    }

    public boolean isText() {
        return this == TEXT;
    }

    public boolean isNumber() {
        return this == BYTE || this == INT || this == LONG || this == FLOAT || this == DOUBLE;
    }

    public boolean isNumber4() {
        return this == BYTE || this == INT || this == FLOAT;
    }

    public boolean isNumber8() {
        return this == LONG || this == DOUBLE;
    }

    public boolean isDate() {
        return this == DATE;
    }

    public boolean isUUID() {
        return this == UUID;
    }

    public <V> Number valueToNumber(V value) {
        Number number;
        if (!this.isNumber() || !(value instanceof Number)) {
            return null;
        }
        if (this.clazz.isInstance(value)) {
            return (Number)value;
        }
        try {
            switch (this) {
                case BYTE: {
                    number = Byte.valueOf(value.toString());
                    break;
                }
                case INT: {
                    number = Integer.valueOf(value.toString());
                    break;
                }
                case LONG: {
                    number = Long.valueOf(value.toString());
                    break;
                }
                case FLOAT: {
                    number = Float.valueOf(value.toString());
                    break;
                }
                case DOUBLE: {
                    number = Double.valueOf(value.toString());
                    break;
                }
                default: {
                    throw new AssertionError((Object)String.format("Number type only contains Byte, Integer, Long, Float, Double, but got %s", this.clazz()));
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Can't read '%s' as %s: %s", value, this.name, e.getMessage()));
        }
        return number;
    }

    public <V> Date valueToDate(V value) {
        if (!this.isDate()) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Integer) {
            return new Date(((Number)value).intValue());
        }
        if (value instanceof Long) {
            return new Date(((Number)value).longValue());
        }
        if (value instanceof String) {
            return DateUtil.parse((String)((String)value));
        }
        return null;
    }

    public <V> UUID valueToUUID(V value) {
        if (!this.isUUID()) {
            return null;
        }
        if (value instanceof UUID) {
            return (UUID)value;
        }
        if (value instanceof String) {
            return StringEncoding.uuid((String)value);
        }
        return null;
    }

    public static DataType fromClass(Class<?> clazz) {
        for (DataType type : DataType.values()) {
            if (type.clazz() != clazz) continue;
            return type;
        }
        throw new HugeException("Unknown clazz '%s' for DataType", clazz);
    }

    static {
        $VALUES = new DataType[]{UNKNOWN, OBJECT, BOOLEAN, BYTE, INT, LONG, FLOAT, DOUBLE, TEXT, DATE, UUID};
        DataType.register(DataType.class);
        TABLE = HashBasedTable.create();
    }
}

