/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.reflect.impl;

import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.Parameter;
import org.simpleflatmapper.util.BiFunction;
import org.simpleflatmapper.util.TypeHelper;

public final class BiArgumentBuilder<S1, S2> {
    private static final BiFunction NULL_FACTORIES = new BiFunction(){

        public Object apply(Object o, Object o2) {
            return null;
        }
    };
    private static final Map<Class<?>, BiFunction> DEFAULT_FACTORIES = new HashMap();
    private final BiFunction<? super S1, ? super S2, ?>[] factories;

    public BiArgumentBuilder(InstantiatorDefinition instantiatorDefinition, Map<Parameter, BiFunction<? super S1, ? super S2, ?>> injections) {
        Parameter[] parameters = instantiatorDefinition.getParameters();
        this.factories = new BiFunction[parameters.length];
        for (int i = 0; i < this.factories.length; ++i) {
            Parameter param = parameters[i];
            BiFunction factory = injections.get(param);
            if (factory == null) {
                factory = TypeHelper.isPrimitive(param.getType()) ? DEFAULT_FACTORIES.get(param.getType()) : NULL_FACTORIES;
            }
            this.factories[i] = factory;
        }
    }

    public Object[] build(S1 s1, S2 s2) throws Exception {
        Object[] args = new Object[this.factories.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = this.factories[i].apply(s1, s2);
        }
        return args;
    }

    static {
        DEFAULT_FACTORIES.put(Boolean.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return Boolean.TRUE;
            }
        });
        DEFAULT_FACTORIES.put(Byte.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return (byte)0;
            }
        });
        DEFAULT_FACTORIES.put(Character.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return Character.valueOf('\u0000');
            }
        });
        DEFAULT_FACTORIES.put(Short.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return (short)0;
            }
        });
        DEFAULT_FACTORIES.put(Integer.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return 0;
            }
        });
        DEFAULT_FACTORIES.put(Long.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return 0L;
            }
        });
        DEFAULT_FACTORIES.put(Float.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return Float.valueOf(0.0f);
            }
        });
        DEFAULT_FACTORIES.put(Double.TYPE, new BiFunction(){

            public Object apply(Object o, Object o2) {
                return 0.0;
            }
        });
    }
}

