/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.loader.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.temporal.JulianFields;
import java.util.Date;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.Type;

public class ParquetUtil {
    public static Object convertObject(Group group, int fieldIndex) {
        Object object;
        Type fieldType = group.getType().getType(fieldIndex);
        if (!fieldType.isPrimitive()) {
            throw new LoadException("Unsupported rich object type %s", fieldType);
        }
        String fieldName = fieldType.getName();
        if (group.getFieldRepetitionCount(fieldName) == 0) {
            return null;
        }
        switch (fieldType.asPrimitiveType().getPrimitiveTypeName()) {
            case INT32: {
                object = group.getInteger(fieldName, 0);
                break;
            }
            case INT64: {
                object = group.getLong(fieldName, 0);
                break;
            }
            case INT96: {
                object = ParquetUtil.dateFromInt96(group.getInt96(fieldName, 0));
                break;
            }
            case FLOAT: {
                object = Float.valueOf(group.getFloat(fieldName, 0));
                break;
            }
            case DOUBLE: {
                object = group.getDouble(fieldName, 0);
                break;
            }
            case BOOLEAN: {
                object = group.getBoolean(fieldName, 0);
                break;
            }
            default: {
                object = group.getValueToString(fieldIndex, 0);
            }
        }
        return object;
    }

    private static Date dateFromInt96(Binary value) {
        byte[] int96Bytes = value.getBytes();
        int julianDay = 0;
        int index = int96Bytes.length;
        while (index > 8) {
            julianDay <<= 8;
            julianDay += int96Bytes[--index] & 0xFF;
        }
        long nanos = 0L;
        while (index > 0) {
            nanos <<= 8;
            nanos += (long)(int96Bytes[--index] & 0xFF);
        }
        LocalDateTime timestamp = LocalDate.MIN.with(JulianFields.JULIAN_DAY, julianDay).atTime(LocalTime.NOON).plusNanos(nanos);
        return Date.from(timestamp.atZone(ZoneId.systemDefault()).toInstant());
    }
}

