/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.service.load;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.Date;
import java.util.List;
import org.apache.hugegraph.entity.enums.JobStatus;
import org.apache.hugegraph.entity.enums.LoadStatus;
import org.apache.hugegraph.entity.load.JobManager;
import org.apache.hugegraph.entity.load.LoadTask;
import org.apache.hugegraph.exception.InternalException;
import org.apache.hugegraph.mapper.load.JobManagerMapper;
import org.apache.hugegraph.service.load.LoadTaskService;
import org.apache.hugegraph.util.HubbleUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobManagerService {
    private static final Logger log = LogManager.getLogger(JobManagerService.class);
    @Autowired
    private JobManagerMapper mapper;
    @Autowired
    private LoadTaskService taskService;

    public int count() {
        return this.mapper.selectCount(null);
    }

    public JobManager get(int id) {
        return (JobManager)this.mapper.selectById(Integer.valueOf(id));
    }

    public JobManager getTask(String jobName, int connId) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"job_name", (Object)jobName);
        query.eq((Object)"conn_id", (Object)connId);
        return (JobManager)this.mapper.selectOne((Wrapper)query);
    }

    public List<JobManager> list(int connId, List<Integer> jobIds) {
        return this.mapper.selectBatchIds(jobIds);
    }

    public IPage<JobManager> list(int connId, int pageNo, int pageSize, String content) {
        QueryWrapper query = Wrappers.query();
        query.eq((Object)"conn_id", (Object)connId);
        if (!content.isEmpty()) {
            query.like((Object)"job_name", (Object)content);
        }
        query.orderByDesc((Object)"create_time");
        Page page = new Page((long)pageNo, (long)pageSize);
        IPage list = this.mapper.selectPage((IPage)page, (Wrapper)query);
        list.getRecords().forEach(task -> {
            if (task.getJobStatus() == JobStatus.LOADING) {
                List<LoadTask> tasks = this.taskService.taskListByJob(task.getId());
                JobStatus status = JobStatus.SUCCESS;
                for (LoadTask loadTask : tasks) {
                    if (loadTask.getStatus().inRunning() || loadTask.getStatus() == LoadStatus.PAUSED || loadTask.getStatus() == LoadStatus.STOPPED) {
                        status = JobStatus.LOADING;
                        break;
                    }
                    if (loadTask.getStatus() != LoadStatus.FAILED) continue;
                    status = JobStatus.FAILED;
                    break;
                }
                if (status == JobStatus.SUCCESS || status == JobStatus.FAILED) {
                    task.setJobStatus(status);
                    this.update((JobManager)task);
                }
            }
            Date endDate = task.getJobStatus() == JobStatus.FAILED || task.getJobStatus() == JobStatus.SUCCESS ? task.getUpdateTime() : HubbleUtil.nowDate();
            task.setJobDuration(endDate.getTime() - task.getCreateTime().getTime());
        });
        return list;
    }

    public List<JobManager> listAll() {
        return this.mapper.selectList(null);
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void save(JobManager entity) {
        if (this.mapper.insert(entity) != 1) {
            throw new InternalException("entity.insert.failed", entity);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void update(JobManager entity) {
        if (this.mapper.updateById(entity) != 1) {
            throw new InternalException("entity.update.failed", entity);
        }
    }

    @Transactional(isolation=Isolation.READ_COMMITTED)
    public void remove(int id) {
        if (this.mapper.deleteById(Integer.valueOf(id)) != 1) {
            throw new InternalException("entity.delete.failed", id);
        }
    }
}

