/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Threads {
    private static final Logger LOG = LoggerFactory.getLogger(Threads.class);
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    public static final Thread.UncaughtExceptionHandler LOGGING_EXCEPTION_HANDLER = new Thread.UncaughtExceptionHandler(){

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            LOG.warn("Thread:" + t + " exited with Exception:" + StringUtils.stringifyException((Throwable)e));
        }
    };

    public static <T extends Thread> T setDaemonThreadRunning(T t) {
        return Threads.setDaemonThreadRunning(t, t.getName());
    }

    public static <T extends Thread> T setDaemonThreadRunning(T t, String name) {
        return Threads.setDaemonThreadRunning(t, name, null);
    }

    public static <T extends Thread> T setDaemonThreadRunning(T t, String name, Thread.UncaughtExceptionHandler handler) {
        t.setName(name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.setDaemon(true);
        t.start();
        return t;
    }

    public static void shutdown(Thread t) {
        Threads.shutdown(t, 0L);
    }

    public static void shutdown(Thread t, long joinwait) {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            try {
                t.join(joinwait);
            }
            catch (InterruptedException e) {
                LOG.warn(t.getName() + "; joinwait=" + joinwait, (Throwable)e);
            }
        }
    }

    public static void threadDumpingIsAlive(Thread t) throws InterruptedException {
        if (t == null) {
            return;
        }
        while (t.isAlive()) {
            t.join(60000L);
            if (!t.isAlive()) continue;
            Threads.printThreadInfo(System.out, "Automatic Stack Trace every 60 seconds waiting on " + t.getName());
        }
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            LOG.warn("sleep interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public static void sleepWithoutInterrupt(long msToWait) {
        long timeMillis = System.currentTimeMillis();
        long endTime = timeMillis + msToWait;
        boolean interrupted = false;
        while (timeMillis < endTime) {
            try {
                Thread.sleep(endTime - timeMillis);
            }
            catch (InterruptedException ex) {
                interrupted = true;
            }
            timeMillis = System.currentTimeMillis();
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public static ThreadPoolExecutor getBoundedCachedThreadPool(int maxCachedThread, long timeout, TimeUnit unit, ThreadFactory threadFactory) {
        ThreadPoolExecutor boundedCachedThreadPool = new ThreadPoolExecutor(maxCachedThread, maxCachedThread, timeout, unit, new LinkedBlockingQueue<Runnable>(), threadFactory);
        boundedCachedThreadPool.allowCoreThreadTimeOut(true);
        return boundedCachedThreadPool;
    }

    private static ThreadFactory getNamedThreadFactory(final String prefix) {
        SecurityManager s = System.getSecurityManager();
        final ThreadGroup threadGroup = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        return new ThreadFactory(){
            final AtomicInteger threadNumber = new AtomicInteger(1);
            private final int poolNumber = Threads.access$100().getAndIncrement();
            final ThreadGroup group = threadGroup;

            @Override
            public Thread newThread(Runnable r) {
                String name = prefix + "-pool" + this.poolNumber + "-t" + this.threadNumber.getAndIncrement();
                return new Thread(this.group, r, name);
            }
        };
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix) {
        return Threads.newDaemonThreadFactory(prefix, null);
    }

    public static ThreadFactory newDaemonThreadFactory(String prefix, final Thread.UncaughtExceptionHandler handler) {
        final ThreadFactory namedFactory = Threads.getNamedThreadFactory(prefix);
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = namedFactory.newThread(r);
                if (handler != null) {
                    t.setUncaughtExceptionHandler(handler);
                } else {
                    t.setUncaughtExceptionHandler(LOGGING_EXCEPTION_HANDLER);
                }
                if (!t.isDaemon()) {
                    t.setDaemon(true);
                }
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        };
    }

    public static void setLoggingUncaughtExceptionHandler(Thread t) {
        t.setUncaughtExceptionHandler(LOGGING_EXCEPTION_HANDLER);
    }

    public static void printThreadInfo(PrintStream stream, String title) {
        Preconditions.checkNotNull(PrintThreadInfoLazyHolder.HELPER, "Cannot find method. Check hadoop jars linked").printThreadInfo(stream, title);
    }

    static /* synthetic */ AtomicInteger access$100() {
        return poolNumber;
    }

    private static class PrintThreadInfoLazyHolder {
        public static final PrintThreadInfoHelper HELPER = PrintThreadInfoLazyHolder.initHelper();

        private PrintThreadInfoLazyHolder() {
        }

        private static PrintThreadInfoHelper initHelper() {
            Method method = null;
            try {
                method = ReflectionUtils.class.getMethod("printThreadInfo", PrintStream.class, String.class);
                method.setAccessible(true);
                final Method hadoop27Method = method;
                return new PrintThreadInfoHelper(){

                    @Override
                    public void printThreadInfo(PrintStream stream, String title) {
                        try {
                            hadoop27Method.invoke(null, stream, title);
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            throw new RuntimeException(e);
                        }
                        catch (InvocationTargetException e) {
                            throw new RuntimeException(e.getCause());
                        }
                    }
                };
            }
            catch (NoSuchMethodException e) {
                LOG.info("Can not find hadoop 2.7+ printThreadInfo method, try hadoop hadoop 2.6 and earlier", (Throwable)e);
                try {
                    method = ReflectionUtils.class.getMethod("printThreadInfo", PrintWriter.class, String.class);
                    method.setAccessible(true);
                    final Method hadoop26Method = method;
                    return new PrintThreadInfoHelper(){

                        @Override
                        public void printThreadInfo(PrintStream stream, String title) {
                            try {
                                hadoop26Method.invoke(null, new PrintWriter(new OutputStreamWriter((OutputStream)stream, StandardCharsets.UTF_8)), title);
                            }
                            catch (IllegalAccessException | IllegalArgumentException e) {
                                throw new RuntimeException(e);
                            }
                            catch (InvocationTargetException e) {
                                throw new RuntimeException(e.getCause());
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e2) {
                    LOG.warn("Cannot find printThreadInfo method. Check hadoop jars linked", (Throwable)e2);
                    return null;
                }
            }
        }
    }

    private static interface PrintThreadInfoHelper {
        public void printThreadInfo(PrintStream var1, String var2);
    }
}

