/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.seqfile;

import com.google.common.collect.Lists;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hugegraph.util.E;

public class ValueFile {
    private static final String SEGMENT_NAME_PREFIX = "value_file_";
    private static final String SEGMENT_NAME_REGEX = "value_file_[0-9]+";
    private static final Pattern FILE_NUM_PATTERN = Pattern.compile("[0-9]+");

    private ValueFile() {
    }

    public static List<File> scanSegment(File dir) {
        E.checkArgument((boolean)dir.isDirectory(), (String)"The parameter dir must be a directory", (Object[])new Object[0]);
        Object[] segments = dir.listFiles((dirName, name) -> name.matches(SEGMENT_NAME_REGEX));
        assert (segments != null);
        Arrays.sort(segments, Comparator.comparingInt(ValueFile::idFromSegment));
        return Lists.newArrayList((Object[])segments);
    }

    public static File segmentFromId(File dir, int segmentId) {
        E.checkArgument((boolean)dir.isDirectory(), (String)"The parameter dir must be a directory", (Object[])new Object[0]);
        String name = SEGMENT_NAME_PREFIX + segmentId;
        return Paths.get(dir.getAbsolutePath(), name).toFile();
    }

    public static long fileLength(File dir) {
        return ValueFile.scanSegment(dir).stream().mapToLong(File::length).sum();
    }

    private static int idFromSegment(File segment) {
        String fileName = segment.getName();
        Matcher matcher = FILE_NUM_PATTERN.matcher(fileName);
        E.checkState((boolean)matcher.find(), (String)"Can't get segment id from illegal file name: '%s'", (Object[])new Object[]{fileName});
        return Integer.parseInt(matcher.group());
    }
}

