/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store.file.bufferfile;

import java.io.File;
import java.io.IOException;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.store.EntryIterator;
import org.apache.hugegraph.computer.core.store.KvEntryFileReader;
import org.apache.hugegraph.computer.core.store.entry.EntriesUtil;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;

public class BufferFileSubEntryReader
implements KvEntryFileReader {
    private final File file;

    public BufferFileSubEntryReader(String path) {
        this.file = new File(path);
    }

    @Override
    public EntryIterator iterator() {
        return new EntryIter();
    }

    private class EntryIter
    implements EntryIterator {
        public final RandomAccessInput input;
        private final RandomAccessInput userAccessInput;

        public EntryIter() {
            try {
                this.input = IOFactory.createFileInput(BufferFileSubEntryReader.this.file);
                this.userAccessInput = this.input.duplicate();
            }
            catch (IOException e) {
                throw new ComputerException(e.getMessage(), (Throwable)e);
            }
        }

        public void close() throws Exception {
            this.input.close();
            this.userAccessInput.close();
        }

        public boolean hasNext() {
            try {
                return this.input.available() > 0L;
            }
            catch (IOException e) {
                throw new ComputerException(e.getMessage(), (Throwable)e);
            }
        }

        public KvEntry next() {
            return EntriesUtil.subKvEntryFromInput(this.input, this.userAccessInput, true);
        }
    }
}

