/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.store;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.FileUtils;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.manager.Manager;
import org.apache.hugegraph.computer.core.store.FileGenerator;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public class FileManager
implements FileGenerator,
Manager {
    private static final Logger LOG = Log.logger(FileManager.class);
    public static final String NAME = "data_dir";
    private List<String> dirs = new ArrayList<String>();
    private AtomicInteger sequence = new AtomicInteger();

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public void init(Config config) {
        String jobId = (String)config.get((TypedOption)ComputerOptions.JOB_ID);
        List paths = (List)config.get((TypedOption)ComputerOptions.WORKER_DATA_DIRS);
        LOG.info("The directories '{}' configured to persist data for job {}", (Object)paths, (Object)jobId);
        for (String path : paths) {
            File dir = new File(path);
            File jobDir = new File(dir, jobId);
            FileManager.mkdirs(jobDir);
            LOG.debug("Initialized directory '{}' to directory list", (Object)jobDir);
            this.dirs.add(jobDir.toString());
        }
        Collections.shuffle(this.dirs);
    }

    @Override
    public void close(Config config) {
        for (String dir : this.dirs) {
            FileUtils.deleteQuietly((File)new File(dir));
        }
    }

    @Override
    public String nextDirectory() {
        int index = this.sequence.incrementAndGet();
        assert (index >= 0);
        return this.dirs.get(index % this.dirs.size());
    }

    @Override
    public List<String> dirs() {
        return this.dirs;
    }

    private static void mkdirs(File dir) {
        if (!dir.mkdirs() && !dir.exists()) {
            throw new ComputerException("Can't create dir %s", new Object[]{dir.getAbsolutePath()});
        }
    }
}

