/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hugegraph.computer.core.sender.QueuedMessage;

public class MultiQueue {
    private final Deque<QueuedMessage>[] deques;
    private int lastTakedQueueId;

    public MultiQueue(int size) {
        this(size, 128);
    }

    public MultiQueue(int size, int capacityPerQueue) {
        this.deques = new ArrayDeque[size];
        for (int i = 0; i < size; ++i) {
            this.deques[i] = new ArrayDeque<QueuedMessage>(capacityPerQueue);
        }
        this.lastTakedQueueId = 0;
    }

    public synchronized void put(int queueId, QueuedMessage message) throws InterruptedException {
        Deque<QueuedMessage> deque = this.deques[queueId];
        deque.addLast(message);
        if (deque.size() == 1) {
            this.notify();
        }
    }

    public synchronized void putAtFront(int queueId, QueuedMessage message) {
        Deque<QueuedMessage> deque = this.deques[queueId];
        deque.addFirst(message);
        if (deque.size() == 1) {
            this.notify();
        }
    }

    public synchronized QueuedMessage take() throws InterruptedException {
        int traverse = 0;
        while (true) {
            QueuedMessage message;
            Deque<QueuedMessage> deque = this.deques[this.lastTakedQueueId++];
            if (this.lastTakedQueueId == this.deques.length) {
                this.lastTakedQueueId = 0;
            }
            if ((message = deque.pollFirst()) != null) {
                return message;
            }
            if (++traverse < this.deques.length) continue;
            this.wait();
            traverse = 0;
        }
    }
}

