/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.receiver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.network.buffer.FileRegionBuffer;
import org.apache.hugegraph.computer.core.network.buffer.NetworkBuffer;
import org.apache.hugegraph.computer.core.receiver.MessageRecvBuffers;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.sort.flusher.OuterSortFlusher;
import org.apache.hugegraph.computer.core.sort.flusher.PeekableIterator;
import org.apache.hugegraph.computer.core.sort.sorting.SortManager;
import org.apache.hugegraph.computer.core.store.SuperstepFileGenerator;
import org.apache.hugegraph.computer.core.store.entry.KvEntry;
import org.apache.hugegraph.computer.core.util.FileUtil;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.util.Log;
import org.slf4j.Logger;

public abstract class MessageRecvPartition {
    public static final Logger LOG = Log.logger(MessageRecvPartition.class);
    private MessageRecvBuffers recvBuffers;
    private MessageRecvBuffers sortBuffers;
    private final SortManager sortManager;
    private List<String> outputFiles;
    private final SuperstepFileGenerator fileGenerator;
    private final boolean withSubKv;
    private final int mergeFileNum;
    private long totalBytes;
    private final boolean useFileRegion;
    private final AtomicReference<Throwable> exception;

    public MessageRecvPartition(Config config, SuperstepFileGenerator fileGenerator, SortManager sortManager, boolean withSubKv) {
        this.fileGenerator = fileGenerator;
        this.sortManager = sortManager;
        this.withSubKv = withSubKv;
        long buffersLimit = (Long)config.get((TypedOption)ComputerOptions.WORKER_RECEIVED_BUFFERS_BYTES_LIMIT);
        long waitSortTimeout = (Long)config.get((TypedOption)ComputerOptions.WORKER_WAIT_SORT_TIMEOUT);
        this.mergeFileNum = (Integer)config.get((TypedOption)ComputerOptions.HGKV_MERGE_FILES_NUM);
        this.useFileRegion = (Boolean)config.get((TypedOption)ComputerOptions.TRANSPORT_RECV_FILE_MODE);
        if (!this.useFileRegion) {
            this.recvBuffers = new MessageRecvBuffers(buffersLimit, waitSortTimeout);
            this.sortBuffers = new MessageRecvBuffers(buffersLimit, waitSortTimeout);
        }
        this.outputFiles = new ArrayList<String>();
        this.totalBytes = 0L;
        this.exception = new AtomicReference();
    }

    public synchronized void addBuffer(NetworkBuffer buffer) {
        this.totalBytes += (long)buffer.length();
        if (buffer instanceof FileRegionBuffer) {
            String path = ((FileRegionBuffer)buffer).path();
            this.outputFiles.add(path);
            return;
        }
        this.recvBuffers.addBuffer(buffer);
        if (this.recvBuffers.full()) {
            this.sortBuffers.waitSorted();
            this.swapReceiveAndSortBuffers();
            this.flushSortBuffersAsync();
        }
    }

    public synchronized PeekableIterator<KvEntry> iterator() {
        if (!this.useFileRegion) {
            this.flushAllBuffersAndWaitSorted();
        }
        this.mergeOutputFilesIfNeeded();
        if (this.outputFiles.size() == 0) {
            return PeekableIterator.emptyIterator();
        }
        return this.sortManager.iterator(this.outputFiles, this.withSubKv);
    }

    public synchronized long totalBytes() {
        return this.totalBytes;
    }

    public synchronized MessageStat messageStat() {
        return new MessageStat(0L, this.totalBytes);
    }

    protected abstract OuterSortFlusher outerSortFlusher();

    protected abstract String type();

    private void flushAllBuffersAndWaitSorted() {
        this.sortBuffers.waitSorted();
        if (this.recvBuffers.totalBytes() > 0L) {
            this.swapReceiveAndSortBuffers();
            this.flushSortBuffersAsync();
            this.sortBuffers.waitSorted();
        }
        this.checkException();
    }

    private void flushSortBuffersAsync() {
        String path = this.genOutputPath();
        this.mergeBuffersAsync(this.sortBuffers, path);
        this.outputFiles.add(path);
    }

    private void mergeBuffersAsync(MessageRecvBuffers buffers, String path) {
        this.checkException();
        this.sortManager.mergeBuffers(buffers.buffers(), path, this.withSubKv, this.outerSortFlusher()).whenComplete((r, e) -> {
            if (e != null) {
                LOG.error("Failed to merge buffers", e);
                this.exception.compareAndSet((Throwable)null, (Throwable)e);
            }
            buffers.signalSorted();
        });
    }

    private void swapReceiveAndSortBuffers() {
        assert (this.recvBuffers.totalBytes() > 0L);
        MessageRecvBuffers oldRecvBuffers = this.recvBuffers;
        this.recvBuffers = this.sortBuffers;
        this.sortBuffers = oldRecvBuffers;
        this.recvBuffers.prepareSort();
    }

    private void mergeOutputFilesIfNeeded() {
        if (this.outputFiles.size() <= 1) {
            return;
        }
        int mergeFileNum = this.mergeFileNum;
        mergeFileNum = 1;
        List<String> newOutputs = this.genOutputFileNames(mergeFileNum);
        this.sortManager.mergeInputs(this.outputFiles, newOutputs, this.withSubKv, this.outerSortFlusher());
        FileUtil.deleteFilesQuietly(this.outputFiles);
        this.outputFiles = newOutputs;
    }

    public String genOutputPath() {
        return this.fileGenerator.nextPath(this.type());
    }

    private List<String> genOutputFileNames(int targetSize) {
        ArrayList<String> files = new ArrayList<String>(targetSize);
        for (int i = 0; i < targetSize; ++i) {
            files.add(this.genOutputPath());
        }
        return files;
    }

    private void checkException() {
        Throwable t = this.exception.get();
        if (t != null) {
            throw new ComputerException(t.getMessage(), t);
        }
    }
}

