/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.structure.graph;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import org.apache.hugegraph.util.E;

public class BatchOlapPropertyRequest {
    @JsonProperty(value="vertices")
    private List<OlapVertex> vertices = null;
    @JsonProperty(value="property_key")
    private String propertyKey = null;

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return String.format("BatchOlapPropertyRequest{vertices=%s,propertyKey=%s}", this.vertices, this.propertyKey);
    }

    public static class OlapVertex {
        @JsonProperty(value="id")
        public Object id;
        @JsonProperty(value="label")
        public String label;
        @JsonProperty(value="value")
        public Object value;

        public String toString() {
            return String.format("OlapVertex{id=%s,label=%s,value=%s}", this.id, this.label, this.value);
        }

        public static class Builder {
            private OlapVertex vertex = new OlapVertex();

            public Builder id(Object id) {
                E.checkArgumentNotNull(id, "The id of vertex can't be null", new Object[0]);
                this.vertex.id = id;
                return this;
            }

            public Builder label(String label) {
                E.checkArgumentNotNull(label, "The label of vertex can't be null", new Object[0]);
                this.vertex.label = label;
                return this;
            }

            public Builder value(Object value) {
                E.checkArgumentNotNull(value, "The value of vertex can't be null", new Object[0]);
                this.vertex.value = value;
                return this;
            }

            public OlapVertex build() {
                E.checkArgumentNotNull(this.vertex.id, "The id of vertex can't be null", new Object[0]);
                E.checkArgumentNotNull(this.vertex.label, "The label of vertex can't be null", new Object[0]);
                E.checkArgumentNotNull(this.vertex.value, "The value of vertex can't be null", new Object[0]);
                return this.vertex;
            }
        }
    }

    public static class Builder {
        private BatchOlapPropertyRequest req = new BatchOlapPropertyRequest();

        private Builder() {
        }

        public Builder vertices(List<OlapVertex> vertices) {
            E.checkArgument(vertices != null && !vertices.isEmpty(), "Parameter 'vertices' can't be null or empty", new Object[0]);
            this.req.vertices = vertices;
            return this;
        }

        public Builder propertyKey(String propertyKey) {
            E.checkArgumentNotNull(propertyKey, "The property key can't be null", new Object[0]);
            this.req.propertyKey = propertyKey;
            return this;
        }

        public BatchOlapPropertyRequest build() {
            E.checkArgumentNotNull(this.req, "BatchOlapPropertyRequest can't be null", new Object[0]);
            E.checkArgumentNotNull(this.req.vertices, "Parameter 'vertices' can't be null", new Object[0]);
            E.checkArgument(this.req.propertyKey != null, "Parameter 'property_key' can't be empty", new Object[0]);
            return this.req;
        }
    }
}

