/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.k8s.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.fabric8.kubernetes.api.model.Quantity;
import java.util.Map;
import java.util.Set;
import org.apache.hugegraph.computer.driver.config.DriverConfigOption;
import org.apache.hugegraph.computer.k8s.Constants;
import org.apache.hugegraph.config.ConfigListOption;
import org.apache.hugegraph.config.ConfigOption;
import org.apache.hugegraph.config.OptionChecker;
import org.apache.hugegraph.config.OptionHolder;

public class KubeSpecOptions
extends OptionHolder {
    private static volatile KubeSpecOptions INSTANCE;
    public static final DriverConfigOption<String> MASTER_CPU;
    public static final DriverConfigOption<String> MASTER_MEMORY;
    public static final ConfigListOption<String> MASTER_COMMAND;
    public static final ConfigListOption<String> MASTER_ARGS;
    public static final DriverConfigOption<String> WORKER_CPU;
    public static final DriverConfigOption<String> WORKER_MEMORY;
    public static final ConfigListOption<String> WORKER_COMMAND;
    public static final ConfigListOption<String> WORKER_ARGS;
    public static final ConfigOption<Integer> WORKER_INSTANCES;
    public static final ConfigOption<String> PULL_POLICY;
    public static final DriverConfigOption<String> JVM_OPTIONS;
    public static final DriverConfigOption<String> REMOTE_JAR_URI;
    public static final ConfigListOption<String> CONFIG_MAP_PATHS;
    public static final ConfigListOption<String> SECRET_PATHS;
    public static final Map<String, ConfigOption<?>> ALLOW_USER_SETTINGS;
    public static final Set<ConfigOption<?>> MAP_TYPE_CONFIGS;

    private KubeSpecOptions() {
    }

    public static synchronized KubeSpecOptions instance() {
        if (INSTANCE == null) {
            INSTANCE = new KubeSpecOptions();
            INSTANCE.registerOptions();
        }
        return INSTANCE;
    }

    public static boolean checkQuantity(String value) {
        try {
            Quantity.parse(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        MASTER_CPU = new DriverConfigOption<String>("k8s.master_cpu", "The cpu limit of master, the unit can be 'm' or without unit detail please refer to\uff1ahttps://kubernetes .io/zh/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu", KubeSpecOptions::checkQuantity, String.class);
        MASTER_MEMORY = new DriverConfigOption<String>("k8s.master_memory", "The memory limit of master, the unit can be one of Ei\u3001Pi\u3001Ti\u3001Gi\u3001Mi\u3001Ki detail please refer to\uff1ahttps://kubernetes .io/zh/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory", KubeSpecOptions::checkQuantity, String.class);
        MASTER_COMMAND = new ConfigListOption<String>("k8s.master_command", "The run command of master, equivalent to 'Entrypoint' field of Docker.", OptionChecker.disallowEmpty(), Constants.COMMAND.toArray(new String[0]));
        MASTER_ARGS = new ConfigListOption<String>("k8s.master_args", "The run args of master, equivalent to 'Cmd' field of Docker.", OptionChecker.disallowEmpty(), Constants.MASTER_ARGS.toArray(new String[0]));
        WORKER_CPU = new DriverConfigOption<String>("k8s.worker_cpu", "The cpu limit of worker, the unit can be 'm' or without unit detail please refer to\uff1ahttps://kubernetes .io/zh/docs/concepts/configuration/manage-resources-containers/#meaning-of-cpu", KubeSpecOptions::checkQuantity, String.class);
        WORKER_MEMORY = new DriverConfigOption<String>("k8s.worker_memory", "The memory limit of worker, the unit can be one of Ei\u3001Pi\u3001Ti\u3001Gi\u3001Mi\u3001Ki detail please refer to\uff1ahttps://kubernetes .io/zh/docs/concepts/configuration/manage-resources-containers/#meaning-of-memory", KubeSpecOptions::checkQuantity, String.class);
        WORKER_COMMAND = new ConfigListOption<String>("k8s.worker_command", "The run command of worker, equivalent to 'Entrypoint' field of Docker.", OptionChecker.disallowEmpty(), Constants.COMMAND.toArray(new String[0]));
        WORKER_ARGS = new ConfigListOption<String>("k8s.worker_args", "The run args of worker, equivalent to 'Cmd' field of Docker.", OptionChecker.disallowEmpty(), Constants.WORKER_ARGS.toArray(new String[0]));
        WORKER_INSTANCES = new ConfigOption<Integer>("k8s.worker_instances", "The number of worker instances, it will instead the 'job.workers_count' option.", OptionChecker.rangeInt(1, Integer.MAX_VALUE), 1);
        PULL_POLICY = new ConfigOption<String>("k8s.pull_policy", "The pull-policy of image.", OptionChecker.allowValues("Always", "Never", "IfNotPresent"), "Always");
        JVM_OPTIONS = new DriverConfigOption<String>("k8s.jvm_options", "The java startup parameters of computer job.", OptionChecker.disallowEmpty(), String.class);
        REMOTE_JAR_URI = new DriverConfigOption<String>("k8s.remote_jar_uri", "The remote jar uri of computer job, it will overlay algorithm image.", OptionChecker.disallowEmpty(), String.class);
        CONFIG_MAP_PATHS = new ConfigListOption<String>("k8s.config_map_paths", "The map of k8s-configmap' name and mount path.", null, new String[]{""});
        SECRET_PATHS = new ConfigListOption<String>("k8s.secret_paths", "The map of k8s-secret' name and mount path.", null, new String[]{""});
        ALLOW_USER_SETTINGS = new ImmutableMap.Builder<String, DriverConfigOption<String>>().put(MASTER_CPU.name(), MASTER_CPU).put(WORKER_CPU.name(), WORKER_CPU).put(MASTER_MEMORY.name(), MASTER_MEMORY).put(WORKER_MEMORY.name(), WORKER_MEMORY).put(WORKER_INSTANCES.name(), (DriverConfigOption<String>)WORKER_INSTANCES).put(JVM_OPTIONS.name(), JVM_OPTIONS).put(REMOTE_JAR_URI.name(), REMOTE_JAR_URI).put(CONFIG_MAP_PATHS.name(), (DriverConfigOption<String>)((Object)CONFIG_MAP_PATHS)).put(SECRET_PATHS.name(), SECRET_PATHS).build();
        MAP_TYPE_CONFIGS = ImmutableSet.of(CONFIG_MAP_PATHS, SECRET_PATHS);
    }
}

