/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traverser;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.hugegraph.api.graph.GraphAPI;
import org.apache.hugegraph.api.traverser.TraversersAPI;
import org.apache.hugegraph.client.RestClient;
import org.apache.hugegraph.rest.RestResult;
import org.apache.hugegraph.structure.constant.Direction;
import org.apache.hugegraph.structure.traverser.SingleSourceJaccardSimilarityRequest;
import org.apache.hugegraph.util.E;

public class JaccardSimilarityAPI
extends TraversersAPI {
    private static final String JACCARD_SIMILARITY = "jaccard_similarity";

    public JaccardSimilarityAPI(RestClient client, String graph) {
        super(client, graph);
    }

    @Override
    protected String type() {
        return "jaccardsimilarity";
    }

    public double get(Object vertexId, Object otherId, Direction direction, String label, long degree) {
        this.client.checkApiVersion("0.51", "jaccard similarity");
        String vertex = GraphAPI.formatVertexId(vertexId, false);
        String other = GraphAPI.formatVertexId(otherId, false);
        JaccardSimilarityAPI.checkDegree(degree);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("vertex", vertex);
        params.put("other", other);
        params.put("direction", (Object)direction);
        params.put("label", label);
        params.put("max_degree", degree);
        RestResult result = this.client.get(this.path(), params);
        Map jaccard = result.readObject(Map.class);
        E.checkState(jaccard.containsKey(JACCARD_SIMILARITY), "The result doesn't have key '%s'", JACCARD_SIMILARITY);
        return (Double)jaccard.get(JACCARD_SIMILARITY);
    }

    public Map<Object, Double> post(SingleSourceJaccardSimilarityRequest request) {
        this.client.checkApiVersion("0.58", "jaccard similar");
        RestResult result = this.client.post(this.path(), request);
        return result.readObject(Map.class);
    }
}

