/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.asm;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.simpleflatmapper.map.FieldKey;
import org.simpleflatmapper.map.FieldMapper;
import org.simpleflatmapper.map.MappingContext;
import org.simpleflatmapper.map.SourceMapper;
import org.simpleflatmapper.map.asm.MapperAsmBuilder;
import org.simpleflatmapper.map.asm.MapperKey;
import org.simpleflatmapper.map.mapper.AbstractMapper;
import org.simpleflatmapper.reflect.BiInstantiator;
import org.simpleflatmapper.reflect.asm.AsmFactory;

public class MapperAsmFactory {
    private final AsmFactory asmFactory;
    private final Map<MapperKey, Constructor<? extends SourceMapper<?, ?>>> fieldMapperCache = new HashMap();

    public MapperAsmFactory(AsmFactory asmFactory) {
        this.asmFactory = asmFactory;
    }

    private <S, T> String generateClassNameForFieldMapper(FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, Class<? super S> source, Class<T> target) {
        StringBuilder sb = new StringBuilder();
        sb.append("org.simpleflatmapper.map.generated.");
        sb.append(this.asmFactory.getPackageName(target));
        sb.append(".AsmMapperFrom").append(this.asmFactory.replaceArray(source.getSimpleName()));
        sb.append("To").append(this.asmFactory.replaceArray(target.getSimpleName()));
        if (constructorMappers.length > 0) {
            sb.append("ConstInj").append(constructorMappers.length);
        }
        if (mappers.length > 0) {
            sb.append("Inj").append(mappers.length);
        }
        sb.append("_I").append(Long.toHexString(this.asmFactory.getNextClassNumber()));
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, T> AbstractMapper<S, T> createMapper(FieldKey<?>[] keys, FieldMapper<S, T>[] mappers, FieldMapper<S, T>[] constructorMappers, BiInstantiator<S, MappingContext<? super S>, T> instantiator, Class<? super S> source, Class<T> target) throws Exception {
        ClassLoader classLoader = target.getClassLoader();
        MapperKey key = MapperKey.of(keys, mappers, constructorMappers, instantiator, target, source);
        Map<MapperKey, Constructor<? extends SourceMapper<?, ?>>> map = this.fieldMapperCache;
        synchronized (map) {
            Constructor<SourceMapper<Object, Object>> constructor = this.fieldMapperCache.get(key);
            if (constructor == null) {
                String className = this.generateClassNameForFieldMapper(mappers, constructorMappers, source, target);
                byte[] bytes = MapperAsmBuilder.dump(className, mappers, constructorMappers, source, target);
                Class type = (Class)this.asmFactory.createClass(className, bytes, classLoader);
                constructor = type.getDeclaredConstructors()[0];
                this.fieldMapperCache.put(key, constructor);
            }
            return (AbstractMapper)constructor.newInstance(mappers, constructorMappers, instantiator);
        }
    }
}

