/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.dem;

import java.awt.image.BufferedImage;

public class Martini {
    private static final double ELEVATION_OFFSET = 10000.0;
    private final int gridSize;
    private final int numTriangles;
    private final int numParentTriangles;
    private final int[] baseCoords;

    public Martini(int gridSize) {
        this.gridSize = gridSize;
        int tileSize = gridSize - 1;
        if ((tileSize & tileSize - 1) != 0) {
            throw new IllegalArgumentException("Expected grid size to be 2^n+1, got " + gridSize + ".");
        }
        this.numTriangles = tileSize * tileSize * 2 - 2;
        this.numParentTriangles = this.numTriangles - tileSize * tileSize;
        this.baseCoords = new int[this.numTriangles * 4];
        for (int i = 0; i < this.numTriangles; ++i) {
            int id = i + 2;
            int ax = 0;
            int ay = 0;
            int bx = 0;
            int by = 0;
            int cx = 0;
            int cy = 0;
            if ((id & 1) != 0) {
                by = cx = tileSize;
                bx = cx;
            } else {
                ay = cy = tileSize;
                ax = cy;
            }
            while ((id >>= 1) > 1) {
                int mx = ax + bx >> 1;
                int my = ay + by >> 1;
                if ((id & 1) != 0) {
                    bx = ax;
                    by = ay;
                    ax = cx;
                    ay = cy;
                } else {
                    ax = bx;
                    ay = by;
                    bx = cx;
                    by = cy;
                }
                cx = mx;
                cy = my;
            }
            int k = i * 4;
            this.baseCoords[k] = ax;
            this.baseCoords[k + 1] = ay;
            this.baseCoords[k + 2] = bx;
            this.baseCoords[k + 3] = by;
        }
    }

    public static double[] createGrid(BufferedImage image) {
        int y;
        int gridSize = image.getWidth() + 1;
        double[] terrain = new double[gridSize * gridSize];
        int tileSize = image.getWidth();
        for (y = 0; y < tileSize; ++y) {
            for (int x = 0; x < tileSize; ++x) {
                int r = image.getRGB(x, y) >> 16 & 0xFF;
                int g = image.getRGB(x, y) >> 8 & 0xFF;
                int b = image.getRGB(x, y) & 0xFF;
                terrain[y * gridSize + x] = (double)(((float)(r * 256 * 256) + (float)g * 256.0f + (float)b) / 10.0f) - 10000.0;
            }
        }
        for (int x = 0; x < gridSize - 1; ++x) {
            terrain[gridSize * (gridSize - 1) + x] = terrain[gridSize * (gridSize - 2) + x];
        }
        for (y = 0; y < gridSize; ++y) {
            terrain[gridSize * y + gridSize - 1] = terrain[gridSize * y + gridSize - 2];
        }
        return terrain;
    }

    public Tile createTile(double[] terrain) {
        return new Tile(terrain, this.gridSize, this.numTriangles, this.numParentTriangles, this.baseCoords);
    }

    public static class Tile {
        private final int gridSize;
        private final int[] indices;
        private final double[] errors;
        private int numVertices;
        private int numTriangles;
        private int[] vertices;
        private int[] triangles;
        private int triIndex = 0;

        private Tile(double[] terrain, int gridSize, int numTriangles, int numParentTriangles, int[] coords) {
            if (terrain.length != gridSize * gridSize) {
                throw new IllegalArgumentException("Expected terrain data of length " + gridSize * gridSize + " (" + gridSize + " x " + gridSize + "), got " + terrain.length + ".");
            }
            this.gridSize = gridSize;
            this.indices = new int[this.gridSize * this.gridSize];
            this.errors = new double[terrain.length];
            for (int i = numTriangles - 1; i >= 0; --i) {
                int k = i * 4;
                int ax = coords[k];
                int ay = coords[k + 1];
                int bx = coords[k + 2];
                int by = coords[k + 3];
                int mx = ax + bx >> 1;
                int my = ay + by >> 1;
                int cx = mx + my - ay;
                int cy = my + ax - mx;
                double interpolatedHeight = (terrain[ay * gridSize + ax] + terrain[by * gridSize + bx]) / 2.0;
                int middleIndex = my * gridSize + mx;
                double middleError = Math.abs(interpolatedHeight - terrain[middleIndex]);
                this.errors[middleIndex] = Math.max(this.errors[middleIndex], middleError);
                if (i >= numParentTriangles) continue;
                int leftChildIndex = (ay + cy >> 1) * gridSize + (ax + cx >> 1);
                int rightChildIndex = (by + cy >> 1) * gridSize + (bx + cx >> 1);
                this.errors[middleIndex] = Math.max(this.errors[middleIndex], Math.max(this.errors[leftChildIndex], this.errors[rightChildIndex]));
            }
        }

        public Mesh getMesh(double maxError) {
            int max = this.gridSize - 1;
            this.numVertices = 0;
            this.numTriangles = 0;
            this.countElements(0, 0, max, max, max, 0, maxError);
            this.countElements(max, max, 0, 0, 0, max, maxError);
            this.vertices = new int[this.numVertices * 2];
            this.triangles = new int[this.numTriangles * 3];
            this.triIndex = 0;
            this.processTriangle(0, 0, max, max, max, 0, maxError);
            this.processTriangle(max, max, 0, 0, 0, max, maxError);
            return new Mesh(this.vertices, this.triangles);
        }

        private void countElements(int ax, int ay, int bx, int by, int cx, int cy, double maxError) {
            int mx = ax + bx >> 1;
            int my = ay + by >> 1;
            if (Math.abs(ax - cx) + Math.abs(ay - cy) > 1 && this.errors[my * this.gridSize + mx] > maxError) {
                this.countElements(cx, cy, ax, ay, mx, my, maxError);
                this.countElements(bx, by, cx, cy, mx, my, maxError);
            } else {
                this.indices[ay * this.gridSize + ax] = this.indices[ay * this.gridSize + ax] != 0 ? this.indices[ay * this.gridSize + ax] : (this.numVertices = this.numVertices + 1);
                this.indices[by * this.gridSize + bx] = this.indices[by * this.gridSize + bx] != 0 ? this.indices[by * this.gridSize + bx] : (this.numVertices = this.numVertices + 1);
                this.indices[cy * this.gridSize + cx] = this.indices[cy * this.gridSize + cx] != 0 ? this.indices[cy * this.gridSize + cx] : (this.numVertices = this.numVertices + 1);
                ++this.numTriangles;
            }
        }

        private void processTriangle(int ax, int ay, int bx, int by, int cx, int cy, double maxError) {
            int mx = ax + bx >> 1;
            int my = ay + by >> 1;
            if (Math.abs(ax - cx) + Math.abs(ay - cy) > 1 && this.errors[my * this.gridSize + mx] > maxError) {
                this.processTriangle(cx, cy, ax, ay, mx, my, maxError);
                this.processTriangle(bx, by, cx, cy, mx, my, maxError);
            } else {
                int a = this.indices[ay * this.gridSize + ax] - 1;
                int b = this.indices[by * this.gridSize + bx] - 1;
                int c = this.indices[cy * this.gridSize + cx] - 1;
                this.vertices[2 * a] = ax;
                this.vertices[2 * a + 1] = ay;
                this.vertices[2 * b] = bx;
                this.vertices[2 * b + 1] = by;
                this.vertices[2 * c] = cx;
                this.vertices[2 * c + 1] = cy;
                this.triangles[this.triIndex++] = a;
                this.triangles[this.triIndex++] = b;
                this.triangles[this.triIndex++] = c;
            }
        }
    }

    public static class Mesh {
        private final int[] vertices;
        private final int[] triangles;

        private Mesh(int[] vertices, int[] triangles) {
            this.vertices = vertices;
            this.triangles = triangles;
        }

        public int[] getVertices() {
            return this.vertices;
        }

        public int[] getTriangles() {
            return this.triangles;
        }
    }
}

