/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.List;
import org.apache.sis.coverage.SampleDimension;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverage2D;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.j2d.ColorModelFactory;
import org.apache.sis.coverage.grid.j2d.ObservableImage;
import org.apache.sis.io.stream.ChannelDataInput;
import org.apache.sis.io.stream.InputStreamArrayGetter;
import org.apache.sis.math.Vector;
import org.apache.sis.measure.NumberRange;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.util.j2d.AffineTransform2D;
import org.apache.sis.storage.sql.feature.InfoStatements;
import org.apache.sis.storage.sql.postgis.Band;
import org.apache.sis.storage.sql.postgis.RasterFormat;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public final class RasterReader
extends RasterFormat {
    private AffineTransform2D gridToCRS;
    public CoordinateReferenceSystem defaultCRS;
    private int srid;
    private Band[] bands;
    private transient SampleModel cachedModel;
    private ByteBuffer buffer;

    public RasterReader(InfoStatements spatialRefSys) {
        super(spatialRefSys);
    }

    public void reset() {
        this.gridToCRS = null;
        this.bands = null;
        this.srid = 0;
    }

    public AffineTransform2D getGridToCRS() {
        return this.gridToCRS;
    }

    public int getSRID() {
        return this.srid;
    }

    private boolean needsTransferFunction() {
        for (Band band : this.bands) {
            if (band.noDataValue == null && (band.getDataBufferType() & 8) == 0) continue;
            return true;
        }
        return false;
    }

    private static RasterFormatException malformed(ChannelDataInput input) {
        return new RasterFormatException(Errors.format((short)139, (Object)"WKB", (Object)input.filename));
    }

    public WritableRaster readAsRaster(ChannelDataInput input) throws IOException {
        SampleModel model;
        DataBuffer buffer;
        ByteOrder order;
        switch (input.readUnsignedByte()) {
            case 0: {
                order = ByteOrder.BIG_ENDIAN;
                break;
            }
            case 1: {
                order = ByteOrder.LITTLE_ENDIAN;
                break;
            }
            default: {
                throw RasterReader.malformed(input);
            }
        }
        input.buffer.order(order);
        int version = input.readUnsignedShort();
        if (version != 0) {
            throw new IOException(Errors.format((short)159, (Object)"WKB", (Object)version));
        }
        int numBands = input.readUnsignedShort();
        double scaleX = input.readDouble();
        double scaleY = input.readDouble();
        double ipX = input.readDouble();
        double ipY = input.readDouble();
        double skewX = input.readDouble();
        double skewY = input.readDouble();
        this.gridToCRS = new AffineTransform2D(scaleX, skewY, skewX, scaleY, ipX, ipY);
        this.srid = input.readInt();
        if (numBands == 0) {
            return null;
        }
        int width = input.readUnsignedShort();
        int height = input.readUnsignedShort();
        Band[] bands = new Band[numBands];
        for (int i = 0; i < numBands; ++i) {
            Object[] data;
            Number nodata;
            Band band = new Band(input.readUnsignedByte());
            int dataType = band.getDataBufferType();
            switch (dataType) {
                case 0: {
                    nodata = input.readUnsignedByte();
                    break;
                }
                case 8: {
                    nodata = input.readByte();
                    break;
                }
                case 2: {
                    nodata = input.readShort();
                    break;
                }
                case 1: {
                    nodata = input.readUnsignedShort();
                    break;
                }
                case 3: {
                    nodata = input.readInt();
                    break;
                }
                case 11: {
                    nodata = input.readUnsignedInt();
                    break;
                }
                case 4: {
                    nodata = Float.valueOf(input.readFloat());
                    break;
                }
                case 5: {
                    nodata = input.readDouble();
                    break;
                }
                default: {
                    throw RasterReader.malformed(input);
                }
            }
            if (band.hasNodata()) {
                band.noDataValue = nodata;
            }
            if (band.isOffline()) {
                throw new RasterFormatException("Offline raster data is not yet supported.");
            }
            int sampleSize = band.getDataTypeSize();
            int elementSize = DataBuffer.getDataTypeSize(dataType);
            int length = Math.toIntExact(Numerics.ceilDiv((long)(Math.multiplyFull(width, height) * (long)sampleSize), (long)elementSize));
            switch (dataType & 0xFFFFFFF7) {
                case 1: 
                case 2: {
                    data = input.readShorts(length);
                    break;
                }
                case 0: {
                    data = input.readBytes(length);
                    break;
                }
                case 3: {
                    data = input.readInts(length);
                    break;
                }
                case 4: {
                    data = band.toNaN(input.readFloats(length));
                    break;
                }
                case 5: {
                    data = band.toNaN(input.readDoubles(length));
                    break;
                }
                default: {
                    throw RasterReader.malformed(input);
                }
            }
            band.data = data;
            bands[i] = band;
        }
        Band firstBand = bands[0];
        int dataType = firstBand.getDataBufferType();
        int length = Array.getLength(firstBand.data);
        Object[] arrays = (Object[])Array.newInstance(firstBand.data.getClass(), numBands);
        arrays[0] = firstBand.data;
        for (int b = 1; b < numBands; ++b) {
            Band band = bands[b];
            if (band.getDataBufferType() != dataType || Array.getLength(band.data) != length) {
                throw new RasterFormatException("Bands of different types are not yet supported.");
            }
            arrays[b] = band.data;
        }
        this.bands = bands;
        switch (dataType &= 0xFFFFFFF7) {
            case 0: {
                buffer = new DataBufferByte((byte[][])arrays, length);
                break;
            }
            case 2: {
                buffer = new DataBufferShort((short[][])arrays, length);
                break;
            }
            case 1: {
                buffer = new DataBufferUShort((short[][])arrays, length);
                break;
            }
            case 3: {
                buffer = new DataBufferInt((int[][])arrays, length);
                break;
            }
            case 4: {
                buffer = new DataBufferFloat((float[][])arrays, length);
                break;
            }
            case 5: {
                buffer = new DataBufferDouble((double[][])arrays, length);
                break;
            }
            default: {
                throw RasterReader.malformed(input);
            }
        }
        int sampleSize = firstBand.getDataTypeSize();
        if (sampleSize >= 8) {
            model = new BandedSampleModel(dataType, width, height, numBands);
        } else if (numBands == 1) {
            model = new MultiPixelPackedSampleModel(dataType, width, height, sampleSize);
        } else {
            throw new RasterFormatException("Multi-bands packed model is not yet supported.");
        }
        if (((Object)model).equals(this.cachedModel)) {
            model = this.cachedModel;
        }
        this.cachedModel = model;
        return WritableRaster.createWritableRaster(model, buffer, null);
    }

    public BufferedImage readAsImage(ChannelDataInput input) throws IOException {
        ColorModel cm;
        WritableRaster raster = this.readAsRaster(input);
        if (raster == null) {
            return null;
        }
        SampleModel sm = raster.getSampleModel();
        int dataType = sm.getDataType();
        int numBands = sm.getNumBands();
        if (numBands == 3 && dataType == 0) {
            cm = ColorModelFactory.createRGB((int)8, (boolean)false, (boolean)false);
        } else {
            double minimum;
            double maximum;
            boolean visibleBand = false;
            if (sm instanceof MultiPixelPackedSampleModel) {
                int sampleSize = ((MultiPixelPackedSampleModel)sm).getPixelBitStride();
                maximum = (1 << sampleSize) - 1;
                minimum = 0.0;
            } else if (dataType == 0) {
                minimum = 0.0;
                maximum = 255.0;
            } else {
                Band band = this.bands[0];
                NumberRange range = Vector.create((Object)band.data, (boolean)band.isUnsigned()).range();
                minimum = range.getMinDouble();
                maximum = range.getMaxDouble();
            }
            cm = ColorModelFactory.createGrayScale((int)dataType, (int)numBands, (int)0, (double)minimum, (double)maximum);
        }
        return new ObservableImage(cm, raster, false, null);
    }

    public GridCoverage readAsCoverage(ChannelDataInput input) throws Exception {
        BufferedImage image = this.readAsImage(input);
        if (image == null) {
            return null;
        }
        CoordinateReferenceSystem crs = null;
        int srid = this.getSRID();
        if (this.spatialRefSys != null) {
            crs = this.spatialRefSys.fetchCRS(srid);
        } else if (srid > 0) {
            crs = CRS.forCode((String)("EPSG:" + srid));
        }
        if (crs == null) {
            crs = this.defaultCRS;
        }
        GridExtent extent = new GridExtent((long)image.getWidth(), (long)image.getHeight());
        GridGeometry domain = new GridGeometry(extent, ANCHOR, (MathTransform)this.getGridToCRS(), crs);
        List<SampleDimension> range = null;
        if (this.needsTransferFunction()) {
            SampleDimension[] sd = new SampleDimension[this.bands.length];
            SampleDimension.Builder builder = new SampleDimension.Builder();
            for (int b = 0; b < sd.length; ++b) {
                Band band = this.bands[b];
                if ((band.getDataBufferType() & 8) != 0) {
                    throw new RasterFormatException("Data type not yet supported.");
                }
                sd[b] = builder.setName(b + 1).setBackground(band.noDataValue).build();
                builder.clear();
            }
            range = Arrays.asList(sd);
        }
        return new GridCoverage2D(domain, range, (RenderedImage)image);
    }

    public ChannelDataInput channel(InputStream input) throws IOException {
        return InputStreamArrayGetter.channel((String)"raster", (InputStream)input, () -> {
            if (this.buffer == null) {
                this.buffer = ByteBuffer.allocate(8192);
            }
            return this.buffer;
        });
    }
}

