/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.file;

import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.file.AbstractHttpFileBuilder;
import com.linecorp.armeria.server.file.ClassPathHttpFile;
import com.linecorp.armeria.server.file.FileSystemHttpFile;
import com.linecorp.armeria.server.file.HttpDataFile;
import com.linecorp.armeria.server.file.HttpFile;
import com.linecorp.armeria.server.file.HttpFileAttributes;
import java.net.URL;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;

public abstract class HttpFileBuilder
extends AbstractHttpFileBuilder {
    HttpFileBuilder() {
    }

    public abstract HttpFile build();

    @Override
    public HttpFileBuilder clock(Clock clock) {
        return (HttpFileBuilder)super.clock(clock);
    }

    @Override
    public HttpFileBuilder date(boolean dateEnabled) {
        return (HttpFileBuilder)super.date(dateEnabled);
    }

    @Override
    public HttpFileBuilder lastModified(boolean lastModifiedEnabled) {
        return (HttpFileBuilder)super.lastModified(lastModifiedEnabled);
    }

    @Override
    public HttpFileBuilder autoDetectedContentType(boolean contentTypeAutoDetectionEnabled) {
        return (HttpFileBuilder)super.autoDetectedContentType(contentTypeAutoDetectionEnabled);
    }

    @Override
    public HttpFileBuilder entityTag(boolean enabled) {
        return (HttpFileBuilder)super.entityTag(enabled);
    }

    @Override
    public HttpFileBuilder entityTag(BiFunction<String, HttpFileAttributes, String> entityTagFunction) {
        return (HttpFileBuilder)super.entityTag(entityTagFunction);
    }

    @Override
    public HttpFileBuilder addHeader(CharSequence name, Object value) {
        return (HttpFileBuilder)super.addHeader(name, value);
    }

    @Override
    public HttpFileBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (HttpFileBuilder)super.addHeaders(headers);
    }

    @Override
    public HttpFileBuilder setHeader(CharSequence name, Object value) {
        return (HttpFileBuilder)super.setHeader(name, value);
    }

    @Override
    public HttpFileBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (HttpFileBuilder)super.setHeaders(headers);
    }

    @Override
    public HttpFileBuilder contentType(MediaType contentType) {
        return (HttpFileBuilder)super.contentType(contentType);
    }

    @Override
    public HttpFileBuilder contentType(CharSequence contentType) {
        return (HttpFileBuilder)super.contentType(contentType);
    }

    @Override
    public HttpFileBuilder cacheControl(CacheControl cacheControl) {
        return (HttpFileBuilder)super.cacheControl(cacheControl);
    }

    @Override
    public HttpFileBuilder cacheControl(CharSequence cacheControl) {
        return (HttpFileBuilder)super.cacheControl(cacheControl);
    }

    static final class HttpDataFileBuilder
    extends HttpFileBuilder {
        private final HttpData content;
        private final long lastModifiedMillis;

        HttpDataFileBuilder(HttpData content, long lastModifiedMillis) {
            this.content = Objects.requireNonNull(content, "content");
            this.lastModifiedMillis = lastModifiedMillis;
        }

        @Override
        public HttpFile build() {
            return new HttpDataFile(this.content, this.clock(), this.lastModifiedMillis, this.isDateEnabled(), this.isLastModifiedEnabled(), this.entityTagFunction(), this.buildHeaders());
        }
    }

    static final class NonExistentHttpFileBuilder
    extends HttpFileBuilder {
        NonExistentHttpFileBuilder() {
        }

        @Override
        public HttpFile build() {
            return HttpFile.nonExistent();
        }
    }

    static final class ClassPathHttpFileBuilder
    extends HttpFileBuilder {
        private final URL url;

        ClassPathHttpFileBuilder(URL url) {
            this.url = Objects.requireNonNull(url, "url");
        }

        @Override
        public HttpFile build() {
            return new ClassPathHttpFile(this.url, this.isContentTypeAutoDetectionEnabled(), this.clock(), this.isDateEnabled(), this.isLastModifiedEnabled(), this.entityTagFunction(), this.buildHeaders());
        }
    }

    static final class FileSystemHttpFileBuilder
    extends HttpFileBuilder {
        private final Path path;

        FileSystemHttpFileBuilder(Path path) {
            this.path = Objects.requireNonNull(path, "path");
        }

        @Override
        public HttpFile build() {
            return new FileSystemHttpFile(this.path, this.isContentTypeAutoDetectionEnabled(), this.clock(), this.isDateEnabled(), this.isLastModifiedEnabled(), this.entityTagFunction(), this.buildHeaders());
        }
    }
}

