/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoder;

import java.util.function.Consumer;
import org.apache.baremaps.geocoder.DataRowMapper;
import org.apache.baremaps.store.DataRow;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRowConsumer
implements Consumer<DataRow> {
    private static final Logger logger = LoggerFactory.getLogger(DataRowConsumer.class);
    private final IndexWriter indexWriter;
    private final DataRowMapper dataRowMapper = new DataRowMapper();

    public DataRowConsumer(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    @Override
    public void accept(DataRow row) {
        try {
            Document document = this.dataRowMapper.apply(row);
            this.indexWriter.addDocument((Iterable)document);
        }
        catch (Exception e) {
            logger.warn("The following row ({}) is not processed due to {}", (Object)row, (Object)e);
        }
    }
}

