/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.util.Arrays;
import java.util.Objects;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterFormatter;
import org.apache.logging.log4j.spi.LoggingSystem;
import org.apache.logging.log4j.spi.recycler.Recycler;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.StringBuilders;

public class ParameterizedMessage
implements Message,
StringBuilderFormattable {
    private static final int DEFAULT_STRING_BUILDER_SIZE = 255;
    private static final Recycler<StringBuilder> STRING_BUILDER_RECYCLER = LoggingSystem.getRecyclerFactory().create(() -> new StringBuilder(255), stringBuilder -> {
        StringBuilders.trimToMaxSize(stringBuilder, 255);
        stringBuilder.setLength(0);
    });
    private final String pattern;
    private final transient Object[] args;
    private final transient Throwable throwable;
    private final ParameterFormatter.MessagePatternAnalysis patternAnalysis;
    private String formattedMessage;

    public ParameterizedMessage(String pattern, Object[] args, Throwable throwable) {
        this.args = args;
        this.pattern = pattern;
        this.patternAnalysis = ParameterFormatter.analyzePattern(pattern, args != null ? args.length : 0);
        this.throwable = ParameterizedMessage.determineThrowable(throwable, this.args, this.patternAnalysis);
    }

    private static Throwable determineThrowable(Throwable throwable, Object[] args, ParameterFormatter.MessagePatternAnalysis analysis) {
        Object lastArg;
        if (throwable != null) {
            return throwable;
        }
        if (args != null && args.length > analysis.placeholderCount && (lastArg = args[args.length - 1]) instanceof Throwable) {
            return (Throwable)lastArg;
        }
        return null;
    }

    public ParameterizedMessage(String pattern, Object ... args) {
        this(pattern, args, null);
    }

    public ParameterizedMessage(String pattern, Object arg) {
        this(pattern, new Object[]{arg});
    }

    public ParameterizedMessage(String pattern, Object arg0, Object arg1) {
        this(pattern, new Object[]{arg0, arg1});
    }

    @Override
    public String getFormat() {
        return this.pattern;
    }

    @Override
    public Object[] getParameters() {
        return this.args;
    }

    @Override
    public Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public String getFormattedMessage() {
        if (this.formattedMessage == null) {
            StringBuilder buffer = STRING_BUILDER_RECYCLER.acquire();
            try {
                this.formatTo(buffer);
                this.formattedMessage = buffer.toString();
            }
            finally {
                STRING_BUILDER_RECYCLER.release(buffer);
            }
        }
        return this.formattedMessage;
    }

    @Override
    public void formatTo(StringBuilder buffer) {
        if (this.formattedMessage != null) {
            buffer.append(this.formattedMessage);
        } else {
            int argCount = this.args != null ? this.args.length : 0;
            ParameterFormatter.formatMessage(buffer, this.pattern, this.args, argCount, this.patternAnalysis);
        }
    }

    public static String format(String pattern, Object[] args) {
        int argCount = args != null ? args.length : 0;
        return ParameterFormatter.format(pattern, args, argCount);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ParameterizedMessage that = (ParameterizedMessage)object;
        return Objects.equals(this.pattern, that.pattern) && Arrays.equals(this.args, that.args);
    }

    public int hashCode() {
        int result = this.pattern != null ? this.pattern.hashCode() : 0;
        result = 31 * result + (this.args != null ? Arrays.hashCode(this.args) : 0);
        return result;
    }

    public static int countArgumentPlaceholders(String pattern) {
        if (pattern == null) {
            return 0;
        }
        return ParameterFormatter.analyzePattern((String)pattern, (int)-1).placeholderCount;
    }

    public static String deepToString(Object o) {
        return ParameterFormatter.deepToString(o);
    }

    public static String identityToString(Object obj) {
        return ParameterFormatter.identityToString(obj);
    }

    public String toString() {
        return "ParameterizedMessage[messagePattern=" + this.pattern + ", stringArgs=" + Arrays.toString(this.args) + ", throwable=" + this.throwable + "]";
    }
}

