/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.im.vector_tiles;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.im.vector_tiles.VectorTilesEncodingExtension;
import mil.nga.geopackage.extension.im.vector_tiles.VectorTilesFieldsDao;
import mil.nga.geopackage.extension.im.vector_tiles.VectorTilesLayers;
import mil.nga.geopackage.extension.im.vector_tiles.VectorTilesLayersDao;
import mil.nga.geopackage.extension.im.vector_tiles.VectorTilesTableCreator;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.geopackage.tiles.user.TileTable;

public class VectorTilesExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "im";
    public static final String EXTENSION_NAME_NO_AUTHOR = "vector_tiles";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("im", "vector_tiles");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "vector_tiles");
    public static final String VECTOR_TILES = "vector-tiles";
    private final VectorTilesLayersDao vectorTilesLayersDao = this.getVectorTilesLayersDao();
    private final VectorTilesFieldsDao vectorTilesFieldsDao = this.getVectorTilesFieldsDao();

    public VectorTilesExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    public static String getName() {
        return EXTENSION_NAME;
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, "gpkgext_vt_layers", null) && this.geoPackage.isTable("gpkgext_vt_layers");
    }

    public boolean createUserVectorTilesTable(String tableName, VectorTilesEncodingExtension vtee) {
        boolean created = false;
        if (!this.geoPackage.isTable(tableName)) {
            this.geoPackage.createTileTable(new TileTable(tableName));
            created = true;
        }
        this.getOrCreate(tableName, vtee);
        return created;
    }

    public List<Extensions> getOrCreate() {
        this.createVectorTilesTables();
        ArrayList<Extensions> extensions = new ArrayList<Extensions>();
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_vt_layers", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        extensions.add(this.getOrCreate(EXTENSION_NAME, "gpkgext_vt_fields", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE));
        return extensions;
    }

    public List<Extensions> getOrCreate(String tilesTable, VectorTilesEncodingExtension vtee) {
        List<Extensions> extensions = this.getOrCreate();
        extensions.add(vtee.getOrCreate(tilesTable));
        return extensions;
    }

    public void removeExtension() {
        try {
            if (this.vectorTilesFieldsDao.isTableExists()) {
                this.geoPackage.dropTable("gpkgext_vt_fields");
            }
            if (this.vectorTilesLayersDao.isTableExists()) {
                List vectorTilesLayers = this.vectorTilesLayersDao.queryForAll();
                for (VectorTilesLayers vectorTilesLayer : vectorTilesLayers) {
                    this.geoPackage.deleteTable(vectorTilesLayer.getTableName());
                    this.extensionsDao.deleteByTableName(vectorTilesLayer.getTableName());
                }
                this.geoPackage.dropTable("gpkgext_vt_layers");
            }
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException var4) {
            throw new GeoPackageException("Failed to delete Vector Tiles extension and/or tables. GeoPackage: " + this.geoPackage.getName(), var4);
        }
    }

    public VectorTilesLayersDao getVectorTilesLayersDao() {
        return VectorTilesExtension.getVectorTilesLayersDao(this.geoPackage);
    }

    public static VectorTilesLayersDao getVectorTilesLayersDao(GeoPackageCore geoPackage) {
        return VectorTilesLayersDao.create(geoPackage);
    }

    public static VectorTilesLayersDao getVectorTilesLayersDao(GeoPackageCoreConnection db) {
        return VectorTilesLayersDao.create(db);
    }

    public VectorTilesFieldsDao getVectorTilesFieldsDao() {
        return VectorTilesExtension.getVectorTilesFieldsDao(this.geoPackage);
    }

    public static VectorTilesFieldsDao getVectorTilesFieldsDao(GeoPackageCore geoPackage) {
        return VectorTilesFieldsDao.create(geoPackage);
    }

    public static VectorTilesFieldsDao getVectorTilesFieldsDao(GeoPackageCoreConnection db) {
        return VectorTilesFieldsDao.create(db);
    }

    public boolean createVectorTilesTables() {
        this.verifyWritable();
        boolean created = false;
        VectorTilesTableCreator tableCreator = new VectorTilesTableCreator(this.geoPackage);
        try {
            if (!this.vectorTilesFieldsDao.isTableExists()) {
                created = tableCreator.createFields() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_vt_fields table exists and create it", e);
        }
        try {
            if (!this.vectorTilesLayersDao.isTableExists()) {
                created = tableCreator.createLayers() > 0 || created;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if gpkgext_vt_layers table exists and create it", e);
        }
        return created;
    }
}

