/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.data.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.data.type.DataType;

public class FloatArrayDataType
implements DataType<float[]> {
    @Override
    public int size(float[] values) {
        return 4 + values.length * 4;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, float[] values) {
        buffer.putInt(position, this.size(values));
        int p = position + 4;
        for (float value : values) {
            buffer.putFloat(p, value);
            p += 4;
        }
    }

    @Override
    public float[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        int length = (size - 4) / 4;
        float[] values = new float[length];
        for (int index = 0; index < length; ++index) {
            values[index] = buffer.getFloat(position + 4 + index * 4);
        }
        return values;
    }
}

