/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.db.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mil.nga.geopackage.db.table.Constraint;
import mil.nga.geopackage.db.table.ConstraintType;

public class Constraints {
    private final List<Constraint> constraints = new ArrayList<Constraint>();
    private final Map<ConstraintType, List<Constraint>> typedContraints = new HashMap<ConstraintType, List<Constraint>>();

    public Constraints() {
    }

    public Constraints(Constraints constraints) {
        for (Constraint constraint : constraints.constraints) {
            this.add(constraint.copy());
        }
    }

    public void add(Constraint constraint) {
        int insertLocation = Collections.binarySearch(this.constraints, constraint);
        if (insertLocation < 0) {
            insertLocation = -(insertLocation + 1);
        }
        this.constraints.add(insertLocation, constraint);
        List<Constraint> typeConstraints = this.typedContraints.get((Object)constraint.getType());
        if (typeConstraints == null) {
            typeConstraints = new ArrayList<Constraint>();
            this.typedContraints.put(constraint.getType(), typeConstraints);
        }
        typeConstraints.add(constraint);
    }

    public void add(Collection<Constraint> constraints) {
        for (Constraint constraint : constraints) {
            this.add(constraint);
        }
    }

    public void add(Constraints constraints) {
        this.add(constraints.all());
    }

    public boolean has() {
        return !this.constraints.isEmpty();
    }

    public boolean has(ConstraintType type) {
        return this.size(type) > 0;
    }

    public int size() {
        return this.constraints.size();
    }

    public int size(ConstraintType type) {
        return this.get(type).size();
    }

    public List<Constraint> all() {
        return this.constraints;
    }

    public Constraint get(int index) {
        return this.constraints.get(index);
    }

    public List<Constraint> get(ConstraintType type) {
        List<Constraint> constraints = this.typedContraints.get((Object)type);
        if (constraints == null) {
            constraints = new ArrayList<Constraint>();
        }
        return constraints;
    }

    public List<Constraint> clear() {
        ArrayList<Constraint> constraintsCopy = new ArrayList<Constraint>(this.constraints);
        this.constraints.clear();
        this.typedContraints.clear();
        return constraintsCopy;
    }

    public List<Constraint> clear(ConstraintType type) {
        List<Constraint> typedConstraints = this.typedContraints.remove((Object)type);
        if (typedConstraints == null) {
            typedConstraints = new ArrayList<Constraint>();
        } else if (!typedConstraints.isEmpty()) {
            Iterator<Constraint> constraintsIterator = this.constraints.iterator();
            while (constraintsIterator.hasNext()) {
                if (constraintsIterator.next().getType() != type) continue;
                constraintsIterator.remove();
            }
        }
        return typedConstraints;
    }

    public Constraints copy() {
        return new Constraints(this);
    }
}

