/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.server.annotation.AnnotatedService;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.HttpResponseException;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RequestCancellationException;
import com.linecorp.armeria.server.RequestTimeoutException;
import com.linecorp.armeria.server.ServerErrorHandler;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultServerErrorHandler
extends Enum<DefaultServerErrorHandler>
implements ServerErrorHandler {
    public static final /* enum */ DefaultServerErrorHandler INSTANCE = new DefaultServerErrorHandler();
    private static final Logger logger;
    private static final /* synthetic */ DefaultServerErrorHandler[] $VALUES;

    public static DefaultServerErrorHandler[] values() {
        return (DefaultServerErrorHandler[])$VALUES.clone();
    }

    public static DefaultServerErrorHandler valueOf(String name) {
        return Enum.valueOf(DefaultServerErrorHandler.class, name);
    }

    @Override
    @Nonnull
    public HttpResponse onServiceException(ServiceRequestContext ctx, Throwable cause) {
        boolean isAnnotatedService;
        ServiceConfig serviceConfig = ctx.config();
        boolean bl = isAnnotatedService = serviceConfig.service().as(AnnotatedService.class) != null;
        if (isAnnotatedService && cause instanceof IllegalArgumentException) {
            return DefaultServerErrorHandler.internalRenderStatus(serviceConfig, ctx.request().headers(), HttpStatus.BAD_REQUEST, cause);
        }
        if (cause instanceof HttpStatusException || cause instanceof HttpResponseException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof ContentTooLargeException) {
            return DefaultServerErrorHandler.internalRenderStatus(serviceConfig, ctx.request().headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, cause);
        }
        if (cause instanceof RequestCancellationException) {
            return HttpResponse.ofFailure(cause);
        }
        if (cause instanceof RequestTimeoutException) {
            return DefaultServerErrorHandler.internalRenderStatus(serviceConfig, ctx.request().headers(), HttpStatus.SERVICE_UNAVAILABLE, cause);
        }
        return DefaultServerErrorHandler.internalRenderStatus(serviceConfig, ctx.request().headers(), HttpStatus.INTERNAL_SERVER_ERROR, cause);
    }

    private static HttpResponse internalRenderStatus(ServiceConfig serviceConfig, RequestHeaders headers, HttpStatus status, @Nullable Throwable cause) {
        AggregatedHttpResponse res = serviceConfig.server().config().errorHandler().renderStatus(serviceConfig, headers, status, null, cause);
        assert (res != null);
        return res.toHttpResponse();
    }

    @Override
    @Nonnull
    public AggregatedHttpResponse renderStatus(ServiceConfig config, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String description, @Nullable Throwable cause) {
        HttpData content;
        if (status.isContentAlwaysEmpty()) {
            return AggregatedHttpResponse.of(ResponseHeaders.of(status));
        }
        try (TemporaryThreadLocals ttl = TemporaryThreadLocals.acquire();){
            StringBuilder buf = ttl.stringBuilder();
            buf.append("Status: ").append(status.codeAsText()).append('\n');
            buf.append("Description: ").append(MoreObjects.firstNonNull(description, status.reasonPhrase())).append('\n');
            if (cause != null && config.verboseResponses() && !status.isSuccess()) {
                buf.append("Stack trace:\n");
                buf.append(Exceptions.traceText(cause));
            }
            content = HttpData.ofUtf8(buf);
        }
        return AggregatedHttpResponse.of(status, MediaType.PLAIN_TEXT_UTF_8, content);
    }

    private static /* synthetic */ DefaultServerErrorHandler[] $values() {
        return new DefaultServerErrorHandler[]{INSTANCE};
    }

    static {
        $VALUES = DefaultServerErrorHandler.$values();
        logger = LoggerFactory.getLogger(DefaultServerErrorHandler.class);
    }
}

