/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent;

import io.servicetalk.concurrent.BlockingSpliterator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;

final class SpliteratorToBlockingSpliterator<T>
implements BlockingSpliterator<T> {
    private final Spliterator<T> spliterator;
    private final AutoCloseable closable;

    SpliteratorToBlockingSpliterator(AutoCloseable closable, Spliterator<T> spliterator) {
        this.spliterator = Objects.requireNonNull(spliterator);
        this.closable = Objects.requireNonNull(closable);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        return this.spliterator.tryAdvance(action);
    }

    @Override
    public BlockingSpliterator<T> trySplit() {
        return new SpliteratorToBlockingSpliterator<T>(this.closable, this.spliterator.trySplit());
    }

    @Override
    public long estimateSize() {
        return this.spliterator.estimateSize();
    }

    @Override
    public int characteristics() {
        return this.spliterator.characteristics();
    }

    @Override
    public void close() throws Exception {
        this.closable.close();
    }
}

