/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api.internal;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.ReadOnlyBufferAllocators;
import io.servicetalk.concurrent.CloseableIterator;
import io.servicetalk.concurrent.internal.AbstractCloseableIteratorAsInputStream;
import java.io.IOException;
import javax.annotation.Nullable;

public final class CloseableIteratorBufferAsInputStream
extends AbstractCloseableIteratorAsInputStream<Buffer> {
    private static final Buffer CLOSED = ReadOnlyBufferAllocators.DEFAULT_RO_ALLOCATOR.fromAscii((CharSequence)"");
    @Nullable
    private Buffer leftover;

    public CloseableIteratorBufferAsInputStream(CloseableIterator<Buffer> iterator) {
        super(iterator);
    }

    protected int leftOverReadableBytes() {
        assert (this.leftover != null);
        return this.leftover.readableBytes();
    }

    protected void leftOverReadBytes(byte[] dst, int offset, int length) {
        assert (this.leftover != null);
        this.leftover.readBytes(dst, offset, length);
    }

    protected boolean hasLeftOver() {
        return this.leftover != null;
    }

    protected void leftOverCheckReset() {
        assert (this.leftover != null);
        if (this.leftover.readableBytes() == 0) {
            this.leftover = null;
        }
    }

    protected void leftOverReset() {
        this.leftover = null;
    }

    protected void nextLeftOver(CloseableIterator<Buffer> iterator) {
        this.leftover = (Buffer)iterator.next();
    }

    protected byte leftOverReadSingleByte() {
        assert (this.leftover != null);
        byte b = this.leftover.readByte();
        this.leftOverCheckReset();
        return b;
    }

    protected boolean isClosed() {
        return this.leftover == CLOSED;
    }

    public void close() throws IOException {
        this.leftover = CLOSED;
        super.close();
    }
}

