/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@JsonTypeName(value="GeoJSON_MultiPolygon")
public class GeoJSONMultiPolygon {
    @Valid
    private TypeEnum type;
    @Valid
    private List<List<List<List<BigDecimal>>>> coordinates = new ArrayList<List<List<List<BigDecimal>>>>();
    @Valid
    private List<BigDecimal> bbox = null;

    public GeoJSONMultiPolygon type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="type")
    @NotNull
    public TypeEnum getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(TypeEnum type) {
        this.type = type;
    }

    public GeoJSONMultiPolygon coordinates(List<List<List<List<BigDecimal>>>> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="coordinates")
    public @NotNull List<List<@Size(min=4) List<@Size(min=2) List<BigDecimal>>>> getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    public void setCoordinates(List<List<List<List<BigDecimal>>>> coordinates) {
        this.coordinates = coordinates;
    }

    public GeoJSONMultiPolygon addCoordinatesItem(List<List<List<BigDecimal>>> coordinatesItem) {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<List<List<List<BigDecimal>>>>();
        }
        this.coordinates.add(coordinatesItem);
        return this;
    }

    public GeoJSONMultiPolygon removeCoordinatesItem(List<List<List<BigDecimal>>> coordinatesItem) {
        if (coordinatesItem != null && this.coordinates != null) {
            this.coordinates.remove(coordinatesItem);
        }
        return this;
    }

    public GeoJSONMultiPolygon bbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="bbox")
    @Size(min=4)
    public @Size(min=4) List<BigDecimal> getBbox() {
        return this.bbox;
    }

    @JsonProperty(value="bbox")
    public void setBbox(List<BigDecimal> bbox) {
        this.bbox = bbox;
    }

    public GeoJSONMultiPolygon addBboxItem(BigDecimal bboxItem) {
        if (this.bbox == null) {
            this.bbox = new ArrayList<BigDecimal>();
        }
        this.bbox.add(bboxItem);
        return this;
    }

    public GeoJSONMultiPolygon removeBboxItem(BigDecimal bboxItem) {
        if (bboxItem != null && this.bbox != null) {
            this.bbox.remove(bboxItem);
        }
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoJSONMultiPolygon geoJSONMultiPolygon = (GeoJSONMultiPolygon)o;
        return Objects.equals((Object)this.type, (Object)geoJSONMultiPolygon.type) && Objects.equals(this.coordinates, geoJSONMultiPolygon.coordinates) && Objects.equals(this.bbox, geoJSONMultiPolygon.bbox);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.coordinates, this.bbox});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoJSONMultiPolygon {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    bbox: ").append(this.toIndentedString(this.bbox)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TypeEnum {
        MULTIPOLYGON(String.valueOf("MultiPolygon"));

        private String value;

        private TypeEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromString(String s) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!Objects.toString(b.value).equals(s)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected string value '" + s + "'");
        }

        @JsonCreator
        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

