/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInnerCoordinatesInner;
import org.apache.baremaps.ogcapi.model.ExtentSpatialGridInnerResolution;

@JsonTypeName(value="extent_spatial_grid_inner")
public class ExtentSpatialGridInner {
    @Valid
    private List<ExtentSpatialGridInnerCoordinatesInner> coordinates = null;
    @Valid
    private Integer cellsCount;
    @Valid
    private ExtentSpatialGridInnerResolution resolution;

    public ExtentSpatialGridInner coordinates(List<ExtentSpatialGridInnerCoordinatesInner> coordinates) {
        this.coordinates = coordinates;
        return this;
    }

    @ApiModelProperty(value="List of coordinates along the dimension for which data organized as an irregular grid in the collection is available (e.g., 2, 10, 80, 100).")
    @JsonProperty(value="coordinates")
    @Size(min=1)
    public @Size(min=1) List<ExtentSpatialGridInnerCoordinatesInner> getCoordinates() {
        return this.coordinates;
    }

    @JsonProperty(value="coordinates")
    public void setCoordinates(List<ExtentSpatialGridInnerCoordinatesInner> coordinates) {
        this.coordinates = coordinates;
    }

    public ExtentSpatialGridInner addCoordinatesItem(ExtentSpatialGridInnerCoordinatesInner coordinatesItem) {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<ExtentSpatialGridInnerCoordinatesInner>();
        }
        this.coordinates.add(coordinatesItem);
        return this;
    }

    public ExtentSpatialGridInner removeCoordinatesItem(ExtentSpatialGridInnerCoordinatesInner coordinatesItem) {
        if (coordinatesItem != null && this.coordinates != null) {
            this.coordinates.remove(coordinatesItem);
        }
        return this;
    }

    public ExtentSpatialGridInner cellsCount(Integer cellsCount) {
        this.cellsCount = cellsCount;
        return this;
    }

    @ApiModelProperty(value="Number of samples available along the dimension for data organized as a regular grid. For values representing the whole area of contiguous cells spanning _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_. For values representing infinitely small point cells spaced by _resolution_ units along the dimension, this will be (_upperBound_ - _lowerBound_) / _resolution_ + 1.")
    @JsonProperty(value="cellsCount")
    public Integer getCellsCount() {
        return this.cellsCount;
    }

    @JsonProperty(value="cellsCount")
    public void setCellsCount(Integer cellsCount) {
        this.cellsCount = cellsCount;
    }

    public ExtentSpatialGridInner resolution(ExtentSpatialGridInnerResolution resolution) {
        this.resolution = resolution;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="resolution")
    public ExtentSpatialGridInnerResolution getResolution() {
        return this.resolution;
    }

    @JsonProperty(value="resolution")
    public void setResolution(ExtentSpatialGridInnerResolution resolution) {
        this.resolution = resolution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentSpatialGridInner extentSpatialGridInner = (ExtentSpatialGridInner)o;
        return Objects.equals(this.coordinates, extentSpatialGridInner.coordinates) && Objects.equals(this.cellsCount, extentSpatialGridInner.cellsCount) && Objects.equals(this.resolution, extentSpatialGridInner.resolution);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.cellsCount, this.resolution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentSpatialGridInner {\n");
        sb.append("    coordinates: ").append(this.toIndentedString(this.coordinates)).append("\n");
        sb.append("    cellsCount: ").append(this.toIndentedString(this.cellsCount)).append("\n");
        sb.append("    resolution: ").append(this.toIndentedString(this.resolution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

