/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.apache.baremaps.ogcapi.model.CollectionInfoDataType;
import org.apache.baremaps.ogcapi.model.ExtentUad;
import org.apache.baremaps.ogcapi.model.Link;

@JsonTypeName(value="collection")
public class Collection {
    @Valid
    private String id;
    @Valid
    private String title;
    @Valid
    private String description;
    @Valid
    private List<Link> links = new ArrayList<Link>();
    @Valid
    private ExtentUad extent;
    @Valid
    private String itemType = "unknown";
    @Valid
    private List<String> crs = null;
    @Valid
    private CollectionInfoDataType dataType;
    @Valid
    private Integer geometryDimension;
    @Valid
    private BigDecimal minScaleDenominator;
    @Valid
    private BigDecimal maxScaleDenominator;
    @Valid
    private BigDecimal minCellSize;
    @Valid
    private BigDecimal maxCellSize;

    public Collection id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="identifier of the collection used, for example, in URIs")
    @JsonProperty(value="id")
    @NotNull
    public String getId() {
        return this.id;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    public Collection title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="human readable title of the collection")
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    public Collection description(String description) {
        this.description = description;
        return this;
    }

    @ApiModelProperty(value="a description of the data in the collection")
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    public Collection links(List<Link> links) {
        this.links = links;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    @JsonProperty(value="links")
    @NotNull
    public List<Link> getLinks() {
        return this.links;
    }

    @JsonProperty(value="links")
    public void setLinks(List<Link> links) {
        this.links = links;
    }

    public Collection addLinksItem(Link linksItem) {
        if (this.links == null) {
            this.links = new ArrayList<Link>();
        }
        this.links.add(linksItem);
        return this;
    }

    public Collection removeLinksItem(Link linksItem) {
        if (linksItem != null && this.links != null) {
            this.links.remove(linksItem);
        }
        return this;
    }

    public Collection extent(ExtentUad extent) {
        this.extent = extent;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="extent")
    public ExtentUad getExtent() {
        return this.extent;
    }

    @JsonProperty(value="extent")
    public void setExtent(ExtentUad extent) {
        this.extent = extent;
    }

    public Collection itemType(String itemType) {
        this.itemType = itemType;
        return this;
    }

    @ApiModelProperty(value="indicator about the type of the items in the collection if the collection has an accessible /collections/{collectionId}/items endpoint")
    @JsonProperty(value="itemType")
    public String getItemType() {
        return this.itemType;
    }

    @JsonProperty(value="itemType")
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    public Collection crs(List<String> crs) {
        this.crs = crs;
        return this;
    }

    @ApiModelProperty(value="the list of coordinate reference systems supported by the API; the first item is the default coordinate reference system")
    @JsonProperty(value="crs")
    public List<String> getCrs() {
        return this.crs;
    }

    @JsonProperty(value="crs")
    public void setCrs(List<String> crs) {
        this.crs = crs;
    }

    public Collection addCrsItem(String crsItem) {
        if (this.crs == null) {
            this.crs = new ArrayList<String>();
        }
        this.crs.add(crsItem);
        return this;
    }

    public Collection removeCrsItem(String crsItem) {
        if (crsItem != null && this.crs != null) {
            this.crs.remove(crsItem);
        }
        return this;
    }

    public Collection dataType(CollectionInfoDataType dataType) {
        this.dataType = dataType;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="dataType")
    public CollectionInfoDataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(CollectionInfoDataType dataType) {
        this.dataType = dataType;
    }

    public Collection geometryDimension(Integer geometryDimension) {
        this.geometryDimension = geometryDimension;
        return this;
    }

    @ApiModelProperty(value="The geometry dimension of the features shown in this layer (0: points, 1: curves, 2: surfaces, 3: solids), unspecified: mixed or unknown")
    @JsonProperty(value="geometryDimension")
    @Min(value=0L)
    @Max(value=3L)
    public @Min(value=0L) @Max(value=3L) Integer getGeometryDimension() {
        return this.geometryDimension;
    }

    @JsonProperty(value="geometryDimension")
    public void setGeometryDimension(Integer geometryDimension) {
        this.geometryDimension = geometryDimension;
    }

    public Collection minScaleDenominator(BigDecimal minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
        return this;
    }

    @ApiModelProperty(value="Minimum scale denominator for usage of the collection")
    @JsonProperty(value="minScaleDenominator")
    public BigDecimal getMinScaleDenominator() {
        return this.minScaleDenominator;
    }

    @JsonProperty(value="minScaleDenominator")
    public void setMinScaleDenominator(BigDecimal minScaleDenominator) {
        this.minScaleDenominator = minScaleDenominator;
    }

    public Collection maxScaleDenominator(BigDecimal maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
        return this;
    }

    @ApiModelProperty(value="Maximum scale denominator for usage of the collection")
    @JsonProperty(value="maxScaleDenominator")
    public BigDecimal getMaxScaleDenominator() {
        return this.maxScaleDenominator;
    }

    @JsonProperty(value="maxScaleDenominator")
    public void setMaxScaleDenominator(BigDecimal maxScaleDenominator) {
        this.maxScaleDenominator = maxScaleDenominator;
    }

    public Collection minCellSize(BigDecimal minCellSize) {
        this.minCellSize = minCellSize;
        return this;
    }

    @ApiModelProperty(value="Minimum cell size for usage of the collection")
    @JsonProperty(value="minCellSize")
    public BigDecimal getMinCellSize() {
        return this.minCellSize;
    }

    @JsonProperty(value="minCellSize")
    public void setMinCellSize(BigDecimal minCellSize) {
        this.minCellSize = minCellSize;
    }

    public Collection maxCellSize(BigDecimal maxCellSize) {
        this.maxCellSize = maxCellSize;
        return this;
    }

    @ApiModelProperty(value="Maximum cell size for usage of the collection")
    @JsonProperty(value="maxCellSize")
    public BigDecimal getMaxCellSize() {
        return this.maxCellSize;
    }

    @JsonProperty(value="maxCellSize")
    public void setMaxCellSize(BigDecimal maxCellSize) {
        this.maxCellSize = maxCellSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collection collection = (Collection)o;
        return Objects.equals(this.id, collection.id) && Objects.equals(this.title, collection.title) && Objects.equals(this.description, collection.description) && Objects.equals(this.links, collection.links) && Objects.equals(this.extent, collection.extent) && Objects.equals(this.itemType, collection.itemType) && Objects.equals(this.crs, collection.crs) && Objects.equals(this.dataType, collection.dataType) && Objects.equals(this.geometryDimension, collection.geometryDimension) && Objects.equals(this.minScaleDenominator, collection.minScaleDenominator) && Objects.equals(this.maxScaleDenominator, collection.maxScaleDenominator) && Objects.equals(this.minCellSize, collection.minCellSize) && Objects.equals(this.maxCellSize, collection.maxCellSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.description, this.links, this.extent, this.itemType, this.crs, this.dataType, this.geometryDimension, this.minScaleDenominator, this.maxScaleDenominator, this.minCellSize, this.maxCellSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Collection {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    links: ").append(this.toIndentedString(this.links)).append("\n");
        sb.append("    extent: ").append(this.toIndentedString(this.extent)).append("\n");
        sb.append("    itemType: ").append(this.toIndentedString(this.itemType)).append("\n");
        sb.append("    crs: ").append(this.toIndentedString(this.crs)).append("\n");
        sb.append("    dataType: ").append(this.toIndentedString(this.dataType)).append("\n");
        sb.append("    geometryDimension: ").append(this.toIndentedString(this.geometryDimension)).append("\n");
        sb.append("    minScaleDenominator: ").append(this.toIndentedString(this.minScaleDenominator)).append("\n");
        sb.append("    maxScaleDenominator: ").append(this.toIndentedString(this.maxScaleDenominator)).append("\n");
        sb.append("    minCellSize: ").append(this.toIndentedString(this.minCellSize)).append("\n");
        sb.append("    maxCellSize: ").append(this.toIndentedString(this.maxCellSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

