/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.ogcapi.model.MbStyle;
import org.apache.baremaps.ogcapi.model.StyleMetadata;
import org.apache.baremaps.ogcapi.model.StyleSet;

@Path(value="/styles")
@Api(description="the styles API")
public interface StylesApi {
    @GET
    @Path(value="/{styleId}")
    @Produces(value={"application/vnd.mapbox.style+json", "application/json"})
    @ApiOperation(value="fetch a style by id", notes="Fetches the style with identifier `styleId`. The set of  available styles can be retrieved at `/styles`.  Not all styles are available in all style encodings.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=200, message="The style", response=MbStyle.class), @ApiResponse(code=404, message="style not found", response=Void.class), @ApiResponse(code=406, message="The requested style encoding is not supported  for this style", response=Void.class)})
    public Response getStyle(@PathParam(value="styleId") @ApiParam(value="Local identifier of a style. \\ A list of all available styles can be found  under the /styles path.") String var1);

    @GET
    @Path(value="/{styleId}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="fetch the metadata about a style", notes="Style metadata is essential information about a style in order to support users to discover and select styles for rendering their data and for visual style editors  to create user interfaces for editing a style.  This operations returns the metadata for the requested style as a single document.  The stylesheet of the style will typically include some the metadata, too.", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=200, message="The metdata for the style.", response=StyleMetadata.class), @ApiResponse(code=404, message="style not found", response=Void.class)})
    public Response getStyleMetadata(@PathParam(value="styleId") @ApiParam(value="Local identifier of a style. \\ A list of all available styles can be found  under the /styles path.") String var1);

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="information about the available styles", notes="This operation fetches the set of styles available. For each style the id, a title, links to the stylesheet of the style in each supported encoding, and the link to the  metadata is provided.  Testbed-15 only requires support for a small number of the styles. Therefore, the currently simple approach is sufficient, but in general the operation should support paging (using a  parameter `limit` and links to the `next` page in responses).", tags={"Styles"})
    @ApiResponses(value={@ApiResponse(code=200, message="the set of available styles", response=StyleSet.class), @ApiResponse(code=400, message="invalid or unknown query parameters", response=Void.class), @ApiResponse(code=406, message="The media types accepted by the client are not  supported for this resource", response=Void.class)})
    public Response getStyleSet();
}

