/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.ogcapi.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.baremaps.ogcapi.model.Collection;
import org.apache.baremaps.ogcapi.model.Collections;

@Path(value="/collections")
@Api(description="the collections API")
public interface CollectionsApi {
    @GET
    @Path(value="/{collectionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the description of a collection available from this service.", notes="", tags={"Collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="Information about a particular collection of (mostly geospatial) data available from this API. The collection is accessible via one or more OGC API set of specifications, for which a link to relevant accessible resources, e.g. /collections/{collectionId}/(items, coverage, map, tiles...) is contained in the response, with the corresponding relation type, as well as key information about the collection. This information includes: * a local identifier for the collection that is unique for the dataset; * a list of coordinate reference systems (CRS) in which data may be returned by the server. The first CRS is the default coordinate reference system (the default is always WGS 84 with axis order longitude/latitude); * an optional title and description for the collection; * an optional extent that can be used to provide an indication of the spatial and temporal extent of the collection - typically derived from the data; * for collections accessible via the Features or Records API, an optional indicator about the type of the items in the collection (the default value, if the indicator is not provided, is 'feature').", response=Collection.class)})
    public Response getCollection(@PathParam(value="collectionId") @ApiParam(value="Local identifier of a collection") String var1);

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Retrieve the list of geospatial data collections available from this service.", notes="", tags={"Collections"})
    @ApiResponses(value={@ApiResponse(code=200, message="The collections of (mostly geospatial) data available from this API. The dataset contains one or more collections. This resource provides information about and access to the collections. The response contains the list of collections. Each collection is accessible via one or more OGC API set of specifications, for which a link to relevant accessible resources, e.g. /collections/{collectionId}/(items, coverage, map, tiles...) is provided, with the corresponding relation type, as well as key information about the collection. This information includes: * a local identifier for the collection that is unique for the dataset; * a list of coordinate reference systems (CRS) in which data may be returned by the server. The first CRS is the default coordinate reference system (the default is always WGS 84 with axis order longitude/latitude); * an optional title and description for the collection; * an optional extent that can be used to provide an indication of the spatial and temporal extent of the collection - typically derived from the data; * for collections accessible via the Features or Records API, an optional indicator about the type of the items in the collection (the default value, if the indicator is not provided, is 'feature').", response=Collections.class)})
    public Response getCollections();
}

