/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.logging.slf4j.internal;

import io.servicetalk.logging.api.LogLevel;
import io.servicetalk.logging.slf4j.internal.FixedLevelLogger;
import java.util.Objects;
import org.slf4j.Logger;

final class DebugLogger
implements FixedLevelLogger {
    private final Logger logger;

    DebugLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger);
    }

    @Override
    public String loggerName() {
        return this.logger.getName();
    }

    @Override
    public LogLevel logLevel() {
        return LogLevel.DEBUG;
    }

    @Override
    public boolean isEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public void log(String msg) {
        this.logger.debug(msg);
    }

    @Override
    public void log(String msg, Throwable cause) {
        this.logger.debug(msg, cause);
    }

    @Override
    public void log(String format, Object arg) {
        this.logger.debug(format, arg);
    }

    @Override
    public void log(String format, Object arg1, Object arg2) {
        this.logger.debug(format, arg1, arg2);
    }

    @Override
    public void log(String format, Object ... args) {
        this.logger.debug(format, args);
    }
}

