/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPInputStream;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record UngzipFile(Path file, Path directory) implements Task
{
    private static final Logger logger = LoggerFactory.getLogger(UngzipFile.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path filePath = this.file.toAbsolutePath();
        Path directoryPath = this.directory.toAbsolutePath();
        try (GZIPInputStream zis = new GZIPInputStream(new BufferedInputStream(Files.newInputStream(filePath, new OpenOption[0])));){
            Path decompressed = directoryPath.resolve(filePath.getFileName().toString().substring(0, filePath.getFileName().toString().length() - 3));
            if (!Files.exists(decompressed, new LinkOption[0])) {
                Files.createDirectories(decompressed.getParent(), new FileAttribute[0]);
                Files.createFile(decompressed, new FileAttribute[0]);
            }
            Files.copy(zis, decompressed, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new WorkflowException(e);
        }
    }
}

