/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.postgres;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.baremaps.database.schema.DataColumn;
import org.apache.baremaps.database.schema.DataColumnImpl;
import org.apache.baremaps.database.schema.DataRow;
import org.apache.baremaps.database.schema.DataRowType;
import org.apache.baremaps.database.schema.DataRowTypeImpl;
import org.apache.baremaps.database.schema.DataSchema;
import org.apache.baremaps.database.schema.DataTable;
import org.apache.baremaps.database.schema.DataTableException;
import org.apache.baremaps.postgres.copy.CopyWriter;
import org.apache.baremaps.postgres.copy.GeometryValueHandler;
import org.apache.baremaps.postgres.metadata.DatabaseMetadata;
import org.apache.baremaps.postgres.metadata.TableMetadata;
import org.apache.baremaps.storage.postgres.PostgresDataTable;
import org.apache.baremaps.storage.postgres.PostgresTypeConversion;
import org.postgresql.PGConnection;
import org.postgresql.copy.PGCopyOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgresDataSchema
implements DataSchema {
    private static final Logger logger = LoggerFactory.getLogger(PostgresDataSchema.class);
    private static final String[] TYPES = new String[]{"TABLE", "VIEW"};
    private final DataSource dataSource;

    public PostgresDataSchema(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public Collection<String> list() throws DataTableException {
        DatabaseMetadata metadata = new DatabaseMetadata(this.dataSource);
        return metadata.getTableMetaData(null, "public", null, TYPES).stream().map(table -> table.table().tableName()).collect(Collectors.toList());
    }

    @Override
    public DataTable get(String name) throws DataTableException {
        DatabaseMetadata databaseMetadata = new DatabaseMetadata(this.dataSource);
        Optional tableMetadata = databaseMetadata.getTableMetaData(null, null, name, TYPES).stream().findFirst();
        if (tableMetadata.isEmpty()) {
            throw new DataTableException("Table " + name + " does not exist.");
        }
        DataRowType rowType = PostgresDataSchema.createRowType((TableMetadata)tableMetadata.get());
        return new PostgresDataTable(this.dataSource, rowType);
    }

    @Override
    public void add(DataTable table) {
        try (Connection connection = this.dataSource.getConnection();){
            String regex = "[^a-zA-Z0-9]";
            String name = table.rowType().name().replaceAll(regex, "_").toLowerCase();
            HashMap<String, String> mapping = new HashMap<String, String>();
            ArrayList<DataColumn> properties = new ArrayList<DataColumn>();
            for (DataColumn column : table.rowType().columns()) {
                if (!PostgresTypeConversion.typeToName.containsKey((Object)column.type())) continue;
                String columnName = column.name().replaceAll(regex, "_").toLowerCase();
                mapping.put(columnName, column.name());
                properties.add(new DataColumnImpl(columnName, column.type()));
            }
            DataRowTypeImpl rowType = new DataRowTypeImpl(name, properties);
            String dropQuery = this.dropTable(rowType);
            logger.debug(dropQuery);
            try (PreparedStatement dropStatement = connection.prepareStatement(dropQuery);){
                dropStatement.execute();
            }
            String createQuery = this.createTable(rowType);
            logger.debug(createQuery);
            try (PreparedStatement createStatement = connection.prepareStatement(createQuery);){
                createStatement.execute();
            }
            PGConnection pgConnection = connection.unwrap(PGConnection.class);
            String copyQuery = this.copy(rowType);
            logger.debug(copyQuery);
            try (CopyWriter writer = new CopyWriter(new PGCopyOutputStream(pgConnection, copyQuery));){
                writer.writeHeader();
                List<DataColumn> columns = this.getColumns(rowType);
                List<BaseValueHandler> handlers = this.getHandlers(rowType);
                for (DataRow row : table) {
                    writer.startRow(columns.size());
                    for (int i = 0; i < columns.size(); ++i) {
                        String targetColumn = columns.get(i).name();
                        String sourceColumn = (String)mapping.get(targetColumn);
                        Object value = row.get(sourceColumn);
                        if (value == null) {
                            writer.writeNull();
                            continue;
                        }
                        BaseValueHandler handler = handlers.get(i);
                        writer.write(handler, value);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void remove(String name) {
        DataRowType rowType = this.get(name).rowType();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(this.dropTable(rowType));){
            statement.execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected static DataRowType createRowType(TableMetadata tableMetadata) {
        String name = tableMetadata.table().tableName();
        List<DataColumn> columns = tableMetadata.columns().stream().map(column -> new DataColumnImpl(column.columnName(), PostgresTypeConversion.nameToType.get(column.typeName()))).map(DataColumn.class::cast).toList();
        return new DataRowTypeImpl(name, columns);
    }

    protected String dropTable(DataRowType rowType) {
        return String.format("DROP TABLE IF EXISTS \"%s\" CASCADE", rowType.name());
    }

    protected String createTable(DataRowType rowType) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TABLE \"");
        builder.append(rowType.name());
        builder.append("\" (");
        builder.append(rowType.columns().stream().map(column -> "\"" + column.name() + "\" " + PostgresTypeConversion.typeToName.get((Object)column.type())).collect(Collectors.joining(", ")));
        builder.append(")");
        return builder.toString();
    }

    protected String copy(DataRowType rowType) {
        StringBuilder builder = new StringBuilder();
        builder.append("COPY \"");
        builder.append(rowType.name());
        builder.append("\" (");
        builder.append(rowType.columns().stream().map(column -> "\"" + column.name() + "\"").collect(Collectors.joining(", ")));
        builder.append(") FROM STDIN BINARY");
        return builder.toString();
    }

    protected List<DataColumn> getColumns(DataRowType rowType) {
        return rowType.columns().stream().filter(this::isSupported).collect(Collectors.toList());
    }

    protected List<BaseValueHandler> getHandlers(DataRowType rowType) {
        return this.getColumns(rowType).stream().map(column -> this.getHandler(column.type())).collect(Collectors.toList());
    }

    protected BaseValueHandler getHandler(DataColumn.Type type) {
        return switch (type) {
            case DataColumn.Type.STRING -> new StringValueHandler();
            case DataColumn.Type.SHORT -> new ShortValueHandler();
            case DataColumn.Type.INTEGER -> new IntegerValueHandler();
            case DataColumn.Type.LONG -> new LongValueHandler();
            case DataColumn.Type.FLOAT -> new FloatValueHandler();
            case DataColumn.Type.DOUBLE -> new DoubleValueHandler();
            case DataColumn.Type.GEOMETRY -> new GeometryValueHandler();
            case DataColumn.Type.POINT -> new GeometryValueHandler();
            case DataColumn.Type.MULTIPOINT -> new GeometryValueHandler();
            case DataColumn.Type.LINESTRING -> new GeometryValueHandler();
            case DataColumn.Type.MULTILINESTRING -> new GeometryValueHandler();
            case DataColumn.Type.POLYGON -> new GeometryValueHandler();
            case DataColumn.Type.MULTIPOLYGON -> new GeometryValueHandler();
            case DataColumn.Type.GEOMETRYCOLLECTION -> new GeometryValueHandler();
            case DataColumn.Type.INET4_ADDRESS -> new Inet4AddressValueHandler();
            case DataColumn.Type.INET6_ADDRESS -> new Inet6AddressValueHandler();
            case DataColumn.Type.LOCAL_DATE -> new LocalDateValueHandler();
            case DataColumn.Type.LOCAL_TIME -> new LocalTimeValueHandler();
            case DataColumn.Type.LOCAL_DATE_TIME -> new LocalDateTimeValueHandler();
            default -> throw new IllegalArgumentException("Unsupported type: " + type);
        };
    }

    protected boolean isSupported(DataColumn column) {
        return PostgresTypeConversion.typeToName.containsKey((Object)column.type());
    }
}

