/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap;

import java.io.BufferedInputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.GZIPInputStream;
import org.apache.baremaps.database.collection.DataMap;
import org.apache.baremaps.openstreetmap.function.EntityGeometryBuilder;
import org.apache.baremaps.openstreetmap.function.EntityToGeometryMapper;
import org.apache.baremaps.openstreetmap.model.Change;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Header;
import org.apache.baremaps.openstreetmap.model.Node;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.model.Way;
import org.apache.baremaps.openstreetmap.repository.HeaderRepository;
import org.apache.baremaps.openstreetmap.repository.Repository;
import org.apache.baremaps.openstreetmap.xml.XmlChangeReader;
import org.apache.baremaps.stream.ConsumerUtils;
import org.apache.baremaps.stream.StreamException;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.utils.ProjectionTransformer;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiffService
implements Callable<List<TileCoord>> {
    private static final Logger logger = LoggerFactory.getLogger(DiffService.class);
    private final DataMap<Long, Coordinate> coordinateMap;
    private final DataMap<Long, List<Long>> referenceMap;
    private final HeaderRepository headerRepository;
    private final Repository<Long, Node> nodeRepository;
    private final Repository<Long, Way> wayRepository;
    private final Repository<Long, Relation> relationRepository;
    private final int srid;
    private final int zoom;

    public DiffService(DataMap<Long, Coordinate> coordinateMap, DataMap<Long, List<Long>> referenceMap, HeaderRepository headerRepository, Repository<Long, Node> nodeRepository, Repository<Long, Way> wayRepository, Repository<Long, Relation> relationRepository, int srid, int zoom) {
        this.coordinateMap = coordinateMap;
        this.referenceMap = referenceMap;
        this.headerRepository = headerRepository;
        this.nodeRepository = nodeRepository;
        this.wayRepository = wayRepository;
        this.relationRepository = relationRepository;
        this.srid = srid;
        this.zoom = zoom;
    }

    @Override
    public List<TileCoord> call() throws Exception {
        logger.info("Importing changes");
        Header header = this.headerRepository.selectLatest();
        String replicationUrl = header.getReplicationUrl();
        long sequenceNumber = header.getReplicationSequenceNumber() + 1L;
        URL changeUrl = this.resolve(replicationUrl, sequenceNumber, "osc.gz");
        ProjectionTransformer projectionTransformer = new ProjectionTransformer(this.srid, 4326);
        try (GZIPInputStream changeInputStream = new GZIPInputStream(new BufferedInputStream(changeUrl.openStream()));){
            List<TileCoord> list = new XmlChangeReader().stream(changeInputStream).flatMap(this::geometriesForChange).map(arg_0 -> ((ProjectionTransformer)projectionTransformer).transform(arg_0)).flatMap(this::tilesForGeometry).distinct().toList();
            return list;
        }
    }

    private Stream<TileCoord> tilesForGeometry(Geometry geometry) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(TileCoord.iterator(geometry.getEnvelopeInternal(), this.zoom, this.zoom), 1024), false);
    }

    private Stream<Geometry> geometriesForChange(Change change) {
        switch (change.getType()) {
            case CREATE: {
                return this.geometriesForNextVersion(change);
            }
            case DELETE: {
                return this.geometriesForPreviousVersion(change);
            }
            case MODIFY: {
                return Stream.concat(this.geometriesForPreviousVersion(change), this.geometriesForNextVersion(change));
            }
        }
        return Stream.empty();
    }

    private Stream<Geometry> geometriesForPreviousVersion(Change change) {
        return change.getEntities().stream().map(this::geometriesForPreviousVersion).flatMap(Optional::stream);
    }

    private Optional<Geometry> geometriesForPreviousVersion(Entity entity) {
        try {
            if (entity instanceof Node) {
                Node node = (Node)entity;
                Node previousNode = this.nodeRepository.get(node.id());
                return Optional.ofNullable(previousNode).map(Element::getGeometry);
            }
            if (entity instanceof Way) {
                Way way = (Way)entity;
                Way previousWay = this.wayRepository.get(way.id());
                return Optional.ofNullable(previousWay).map(Element::getGeometry);
            }
            if (entity instanceof Relation) {
                Relation relation = (Relation)entity;
                Relation previousRelation = this.relationRepository.get(relation.id());
                return Optional.ofNullable(previousRelation).map(Element::getGeometry);
            }
            return Optional.empty();
        }
        catch (Exception e) {
            throw new StreamException(e);
        }
    }

    private Stream<Geometry> geometriesForNextVersion(Change change) {
        return change.getEntities().stream().map(ConsumerUtils.consumeThenReturn(new EntityGeometryBuilder(this.coordinateMap, this.referenceMap))).flatMap(new EntityToGeometryMapper().andThen(Optional::stream));
    }

    public URL resolve(String replicationUrl, Long sequenceNumber, String extension) throws MalformedURLException {
        String s = String.format("%09d", sequenceNumber);
        String uri = String.format("%s/%s/%s/%s.%s", replicationUrl, s.substring(0, 3), s.substring(3, 6), s.substring(6, 9), extension);
        return URI.create(uri).toURL();
    }
}

