/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.geocoderosm;

import java.util.function.Consumer;
import org.apache.baremaps.geocoderosm.GeocoderOsmDocumentMapper;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeocoderOsmConsumerEntity
implements Consumer<Entity> {
    private final IndexWriter indexWriter;
    private final GeocoderOsmDocumentMapper geocoderOsmDocumentMapper = new GeocoderOsmDocumentMapper();
    private static final Logger logger = LoggerFactory.getLogger(GeocoderOsmConsumerEntity.class);

    public GeocoderOsmConsumerEntity(IndexWriter indexWriter) {
        this.indexWriter = indexWriter;
    }

    @Override
    public void accept(Entity entity) {
        try {
            if (entity instanceof Element) {
                Element element = (Element)entity;
                Document document = this.geocoderOsmDocumentMapper.apply(element);
                this.indexWriter.addDocument((Iterable)document);
            }
        }
        catch (Exception e) {
            logger.warn("The following OSM entity ({}) is not processed due to {}", (Object)entity, (Object)e);
        }
    }
}

