/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.CoordinateArrayDataType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;

public class PolygonDataType
implements DataType<Polygon> {
    private final CoordinateArrayDataType coordinateArrayDataType = new CoordinateArrayDataType();
    private final GeometryFactory geometryFactory;

    public PolygonDataType() {
        this(new GeometryFactory());
    }

    public PolygonDataType(GeometryFactory geometryFactory) {
        this.geometryFactory = geometryFactory;
    }

    @Override
    public int size(Polygon value) {
        int size = 4;
        LinearRing exteriorRing = value.getExteriorRing();
        size += this.coordinateArrayDataType.size(exteriorRing.getCoordinates());
        for (int i = 0; i < value.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = value.getInteriorRingN(i);
            size += this.coordinateArrayDataType.size(interiorRing.getCoordinates());
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return this.coordinateArrayDataType.size(buffer, position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, Polygon value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        LinearRing exteriorRing = value.getExteriorRing();
        this.coordinateArrayDataType.write(buffer, p, exteriorRing.getCoordinates());
        p += this.coordinateArrayDataType.size(exteriorRing.getCoordinates());
        for (int i = 0; i < value.getNumInteriorRing(); ++i) {
            LinearRing interiorRing = value.getInteriorRingN(i);
            this.coordinateArrayDataType.write(buffer, p, interiorRing.getCoordinates());
            p += this.coordinateArrayDataType.size(interiorRing.getCoordinates());
        }
    }

    @Override
    public Polygon read(ByteBuffer buffer, int position) {
        int size = this.size(buffer, position);
        int limit = position + size;
        int p = position + 4;
        Coordinate[] exteriorRingCoordinates = this.coordinateArrayDataType.read(buffer, p);
        LinearRing exteriorRing = this.geometryFactory.createLinearRing(exteriorRingCoordinates);
        p += this.coordinateArrayDataType.size(buffer, p);
        ArrayList<LinearRing> interiorRings = new ArrayList<LinearRing>();
        while (p < limit) {
            Coordinate[] interiorRingCoordinates = this.coordinateArrayDataType.read(buffer, p);
            LinearRing interiorRing = this.geometryFactory.createLinearRing(interiorRingCoordinates);
            interiorRings.add(interiorRing);
            p += this.coordinateArrayDataType.size(buffer, p);
        }
        return this.geometryFactory.createPolygon(exteriorRing, (LinearRing[])interiorRings.toArray(LinearRing[]::new));
    }
}

