/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.GeometryCollectionDataType;
import org.apache.baremaps.database.type.geometry.LineStringDataType;
import org.apache.baremaps.database.type.geometry.MultiLineStringDataType;
import org.apache.baremaps.database.type.geometry.MultiPointDataType;
import org.apache.baremaps.database.type.geometry.MultiPolygonDataType;
import org.apache.baremaps.database.type.geometry.PointDataType;
import org.apache.baremaps.database.type.geometry.PolygonDataType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GeometryDataType
implements DataType<Geometry> {
    private final PointDataType pointDataType;
    private final LineStringDataType lineStringDataType;
    private final PolygonDataType polygonDataType;
    private final MultiPointDataType multiPointDataType;
    private final MultiLineStringDataType multiLineStringDataType;
    private final MultiPolygonDataType multiPolygonDataType;
    private final GeometryCollectionDataType geometryCollectionDataType;

    public GeometryDataType() {
        this(new GeometryFactory());
    }

    public GeometryDataType(GeometryFactory geometryFactory) {
        this.pointDataType = new PointDataType(geometryFactory);
        this.lineStringDataType = new LineStringDataType(geometryFactory);
        this.polygonDataType = new PolygonDataType(geometryFactory);
        this.multiPointDataType = new MultiPointDataType(geometryFactory);
        this.multiLineStringDataType = new MultiLineStringDataType(geometryFactory);
        this.multiPolygonDataType = new MultiPolygonDataType(geometryFactory);
        this.geometryCollectionDataType = new GeometryCollectionDataType(geometryFactory, this);
    }

    @Override
    public int size(Geometry value) {
        int size = 0;
        ++size;
        if (value instanceof Point) {
            Point point = (Point)value;
            size += this.pointDataType.size(point);
        } else if (value instanceof LineString) {
            LineString lineString = (LineString)value;
            size += this.lineStringDataType.size(lineString);
        } else if (value instanceof Polygon) {
            Polygon polygon = (Polygon)value;
            size += this.polygonDataType.size(polygon);
        } else if (value instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)value;
            size += this.multiPointDataType.size(multiPoint);
        } else if (value instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)value;
            size += this.multiLineStringDataType.size(multiLineString);
        } else if (value instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)value;
            size += this.multiPolygonDataType.size(multiPolygon);
        } else if (value instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)value;
            size += this.geometryCollectionDataType.size(geometryCollection);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + value.getClass());
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        int size = 0;
        byte type = buffer.get(position);
        ++size;
        if (type == 1) {
            size += this.pointDataType.size(buffer, position + 1);
        } else if (type == 2) {
            size += this.lineStringDataType.size(buffer, position + 1);
        } else if (type == 3) {
            size += this.polygonDataType.size(buffer, position + 1);
        } else if (type == 4) {
            size += this.multiPointDataType.size(buffer, position + 1);
        } else if (type == 5) {
            size += this.multiLineStringDataType.size(buffer, position + 1);
        } else if (type == 6) {
            size += this.multiPolygonDataType.size(buffer, position + 1);
        } else if (type == 7) {
            size += this.geometryCollectionDataType.size(buffer, position + 1);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + type);
        }
        return size;
    }

    @Override
    public void write(ByteBuffer buffer, int position, Geometry value) {
        if (value == null) {
            buffer.put(position, (byte)0);
        } else if (value instanceof Point) {
            Point point = (Point)value;
            buffer.put(position, (byte)1);
            this.pointDataType.write(buffer, position + 1, point);
        } else if (value instanceof LineString) {
            LineString lineString = (LineString)value;
            buffer.put(position, (byte)2);
            this.lineStringDataType.write(buffer, position + 1, lineString);
        } else if (value instanceof Polygon) {
            Polygon polygon = (Polygon)value;
            buffer.put(position, (byte)3);
            this.polygonDataType.write(buffer, position + 1, polygon);
        } else if (value instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)value;
            buffer.put(position, (byte)4);
            this.multiPointDataType.write(buffer, position + 1, multiPoint);
        } else if (value instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)value;
            buffer.put(position, (byte)5);
            this.multiLineStringDataType.write(buffer, position + 1, multiLineString);
        } else if (value instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)value;
            buffer.put(position, (byte)6);
            this.multiPolygonDataType.write(buffer, position + 1, multiPolygon);
        } else if (value instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)value;
            buffer.put(position, (byte)7);
            this.geometryCollectionDataType.write(buffer, position + 1, geometryCollection);
        } else {
            throw new IllegalArgumentException("Unsupported geometry type: " + value.getClass());
        }
    }

    @Override
    public Geometry read(ByteBuffer buffer, int position) {
        int p = position;
        byte type = buffer.get(p);
        ++p;
        if (type == 0) {
            return null;
        }
        if (type == 1) {
            return this.pointDataType.read(buffer, p);
        }
        if (type == 2) {
            return this.lineStringDataType.read(buffer, p);
        }
        if (type == 3) {
            return this.polygonDataType.read(buffer, p);
        }
        if (type == 4) {
            return this.multiPointDataType.read(buffer, p);
        }
        if (type == 5) {
            return this.multiLineStringDataType.read(buffer, p);
        }
        if (type == 6) {
            return this.multiPolygonDataType.read(buffer, p);
        }
        if (type == 7) {
            return this.geometryCollectionDataType.read(buffer, p);
        }
        throw new IllegalArgumentException("Unsupported geometry type: " + type);
    }
}

