/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.router.jersey;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.http.router.jersey.internal.BufferPublisherInputStream;
import io.servicetalk.http.router.jersey.internal.RequestProperties;
import io.servicetalk.transport.api.ConnectionContext;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.annotation.Priority;
import javax.inject.Provider;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import org.glassfish.jersey.internal.util.collection.Ref;
import org.glassfish.jersey.server.ExtendedUriInfo;
import org.glassfish.jersey.server.model.ResourceMethod;

@Priority(value=4000)
@Consumes(value={"*/*"})
@Produces(value={"*/*"})
abstract class AbstractMessageBodyReaderWriter<Source, T, SourceOfT, WrappedSourceOfT extends SourceOfT>
implements MessageBodyReader<SourceOfT>,
MessageBodyWriter<SourceOfT> {
    private final Class<Source> sourceClass;
    private final Class<T> contentClass;
    @Context
    protected Provider<Ref<ConnectionContext>> ctxRefProvider;
    @Context
    protected Provider<ContainerRequestContext> requestCtxProvider;

    protected AbstractMessageBodyReaderWriter(Class<Source> sourceClass, Class<T> contentClass) {
        this.sourceClass = sourceClass;
        this.contentClass = contentClass;
    }

    public final boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isSupported(genericType);
    }

    final SourceOfT readFrom(InputStream entityStream, BiFunction<Publisher<Buffer>, BufferAllocator, SourceOfT> bodyFunction, Function<SourceOfT, WrappedSourceOfT> sourceFunction) throws WebApplicationException {
        BufferAllocator allocator = ((ConnectionContext)((Ref)this.ctxRefProvider.get()).get()).executionContext().bufferAllocator();
        return (SourceOfT)BufferPublisherInputStream.handleEntityStream((InputStream)entityStream, (BufferAllocator)allocator, bodyFunction, (is, a) -> bodyFunction.andThen(sourceFunction).apply(Publisher.fromInputStream((InputStream)is).map(arg_0 -> ((BufferAllocator)a).wrap(arg_0)), (BufferAllocator)a));
    }

    public final boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !AbstractMessageBodyReaderWriter.isSse((ContainerRequestContext)this.requestCtxProvider.get()) && this.isSupported(genericType);
    }

    final void writeTo(Publisher<Buffer> publisher) throws WebApplicationException {
        RequestProperties.setResponseBufferPublisher(publisher, (ContainerRequestContext)((ContainerRequestContext)this.requestCtxProvider.get()));
    }

    private boolean isSupported(Type entityType) {
        return AbstractMessageBodyReaderWriter.isSourceOfType(entityType, this.sourceClass, this.contentClass);
    }

    static boolean isSourceOfType(Type type, Class<?> sourceClass, Class<?> contentClass) {
        Type typeArgument;
        if (!(type instanceof ParameterizedType)) {
            return false;
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Type rawType = parameterizedType.getRawType();
        return rawType instanceof Class && sourceClass.isAssignableFrom((Class)rawType) && (typeArgument = AbstractMessageBodyReaderWriter.getSingleTypeArgumentOrNull(parameterizedType)) != null && typeArgument instanceof Class && contentClass.isAssignableFrom((Class)typeArgument);
    }

    static int getRequestContentLength(Provider<ContainerRequestContext> requestCtxProvider) {
        return ((ContainerRequestContext)requestCtxProvider.get()).getLength();
    }

    static Buffer newBufferForRequestContent(int contentLength, BufferAllocator allocator) {
        return contentLength == -1 ? allocator.newBuffer() : allocator.newBuffer(contentLength);
    }

    static boolean isSse(ContainerRequestContext requestCtx) {
        ResourceMethod method = ((ExtendedUriInfo)requestCtx.getUriInfo()).getMatchedResourceMethod();
        return method != null && method.isSse();
    }

    @Nullable
    private static Type getSingleTypeArgumentOrNull(ParameterizedType parameterizedType) {
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        return typeArguments.length != 1 ? null : typeArguments[0];
    }
}

