/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.servicetalk.transport.api.ServiceTalkSocketOptions;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public final class SocketOptionUtils {
    private static final Map<SocketOption<?>, OptConverter<?>> SOCKET_OPT_MAP = new HashMap();

    private SocketOptionUtils() {
    }

    public static <T> void addOption(Map<ChannelOption, Object> channelOpts, SocketOption<T> option, T value) {
        OptConverter<?> converter = SOCKET_OPT_MAP.get(option);
        if (converter == null) {
            throw SocketOptionUtils.unsupported(option);
        }
        channelOpts.put(((OptConverter)converter).option, ((OptConverter)converter).toChannelValue.apply(value));
    }

    @Nullable
    public static <T> T getOption(SocketOption<T> option, ChannelConfig config, Long idleTimeoutMs) {
        OptConverter<?> converter = SOCKET_OPT_MAP.get(option);
        if (converter != null) {
            return (T)((OptConverter)converter).toSocketValue.apply(config.getOption(((OptConverter)converter).option));
        }
        if (option == ServiceTalkSocketOptions.IDLE_TIMEOUT) {
            return (T)idleTimeoutMs;
        }
        throw SocketOptionUtils.unsupported(option);
    }

    private static <T> IllegalArgumentException unsupported(SocketOption<T> option) {
        return new IllegalArgumentException("SocketOption(" + option.name() + ", " + option.type().getName() + ") is not supported");
    }

    private static <T> void putOpt(ChannelOption<T> channelOpt, SocketOption<T> socketOpt) {
        SocketOptionUtils.putOpt(channelOpt, socketOpt, Function.identity(), Function.identity());
    }

    private static <T, R> void putOpt(ChannelOption<T> channelOpt, SocketOption<R> socketOpt, Function<T, R> toSocketValue, Function<R, T> toChannelValue) {
        SOCKET_OPT_MAP.put(socketOpt, new OptConverter(channelOpt, toSocketValue, toChannelValue));
    }

    @Nullable
    private static Boolean boolNot(@Nullable Boolean v) {
        return v == null ? null : Boolean.valueOf(v == false);
    }

    static {
        SocketOptionUtils.putOpt(ChannelOption.IP_MULTICAST_IF, StandardSocketOptions.IP_MULTICAST_IF);
        SocketOptionUtils.putOpt(ChannelOption.IP_MULTICAST_LOOP_DISABLED, StandardSocketOptions.IP_MULTICAST_LOOP, SocketOptionUtils::boolNot, SocketOptionUtils::boolNot);
        SocketOptionUtils.putOpt(ChannelOption.IP_MULTICAST_TTL, StandardSocketOptions.IP_MULTICAST_TTL);
        SocketOptionUtils.putOpt(ChannelOption.IP_TOS, StandardSocketOptions.IP_TOS);
        SocketOptionUtils.putOpt(ChannelOption.SO_BROADCAST, StandardSocketOptions.SO_BROADCAST);
        SocketOptionUtils.putOpt(ChannelOption.SO_KEEPALIVE, StandardSocketOptions.SO_KEEPALIVE);
        SocketOptionUtils.putOpt(ChannelOption.SO_LINGER, StandardSocketOptions.SO_LINGER);
        SocketOptionUtils.putOpt(ChannelOption.SO_RCVBUF, StandardSocketOptions.SO_RCVBUF);
        SocketOptionUtils.putOpt(ChannelOption.SO_REUSEADDR, StandardSocketOptions.SO_REUSEADDR);
        SocketOptionUtils.putOpt(ChannelOption.SO_SNDBUF, StandardSocketOptions.SO_SNDBUF);
        SocketOptionUtils.putOpt(ChannelOption.TCP_NODELAY, StandardSocketOptions.TCP_NODELAY);
        SocketOptionUtils.putOpt(ChannelOption.CONNECT_TIMEOUT_MILLIS, ServiceTalkSocketOptions.CONNECT_TIMEOUT);
        SocketOptionUtils.putOpt(ChannelOption.WRITE_BUFFER_WATER_MARK, ServiceTalkSocketOptions.WRITE_BUFFER_THRESHOLD, writeBufferWaterMark -> writeBufferWaterMark == null ? null : Integer.valueOf(writeBufferWaterMark.high()), stThreshold -> new WriteBufferWaterMark(stThreshold >>> 1, stThreshold.intValue()));
        SocketOptionUtils.putOpt(ChannelOption.TCP_FASTOPEN_CONNECT, ServiceTalkSocketOptions.TCP_FASTOPEN_CONNECT);
        SocketOptionUtils.putOpt(ChannelOption.SO_BACKLOG, ServiceTalkSocketOptions.SO_BACKLOG);
        SocketOptionUtils.putOpt(ChannelOption.TCP_FASTOPEN, ServiceTalkSocketOptions.TCP_FASTOPEN_BACKLOG);
    }

    private static final class OptConverter<T> {
        private final ChannelOption<T> option;
        private final Function<T, Object> toSocketValue;
        private final Function<Object, T> toChannelValue;

        private OptConverter(ChannelOption<T> option, Function<T, ?> toSocketValue, Function<?, T> toChannelValue) {
            this.option = option;
            this.toSocketValue = toSocketValue;
            this.toChannelValue = toChannelValue;
        }
    }
}

