/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractMergeCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompletableFixedCountMergeSubscriber;
import io.servicetalk.concurrent.api.MergeOneCompletable;
import java.util.Objects;

final class MergeCompletable
extends AbstractMergeCompletableOperator<CompletableFixedCountMergeSubscriber> {
    private final Completable[] others;
    private final boolean delayError;

    private MergeCompletable(boolean delayError, Completable original, Completable ... others) {
        super(original);
        this.delayError = delayError;
        this.others = Objects.requireNonNull(others);
    }

    static Completable newInstance(boolean delayError, Completable original, Completable ... others) {
        return others.length == 0 ? original : (others.length == 1 ? new MergeOneCompletable(delayError, original, others[0]) : new MergeCompletable(delayError, original, others));
    }

    @Override
    public CompletableFixedCountMergeSubscriber apply(CompletableSource.Subscriber subscriber) {
        return new CompletableFixedCountMergeSubscriber(subscriber, 1 + this.others.length, this.delayError);
    }

    @Override
    void doMerge(CompletableFixedCountMergeSubscriber subscriber) {
        for (Completable itr : this.others) {
            itr.subscribeInternal(subscriber);
        }
    }
}

