/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisher;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FromArrayPublisher<T>
extends AbstractSynchronousPublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FromArrayPublisher.class);
    private final T[] values;

    @SafeVarargs
    FromArrayPublisher(T ... values) {
        this.values = Objects.requireNonNull(values);
    }

    @Override
    void doSubscribe(PublisherSource.Subscriber<? super T> s) {
        if (this.values.length != 0) {
            try {
                s.onSubscribe(new FromArraySubscription<T>(this.values, s));
            }
            catch (Throwable t) {
                SubscriberUtils.handleExceptionFromOnSubscribe(s, (Throwable)t);
            }
        } else {
            SubscriberUtils.deliverCompleteFromSource(s);
        }
    }

    private static final class FromArraySubscription<T>
    implements PublisherSource.Subscription {
        private final PublisherSource.Subscriber<? super T> subscriber;
        private final T[] values;
        private int beginOffset;
        private int endOffset;
        private boolean ignoreRequests;

        FromArraySubscription(T[] values, PublisherSource.Subscriber<? super T> subscriber) {
            this.values = values;
            this.subscriber = subscriber;
        }

        public void request(long n) {
            if (!SubscriberUtils.isRequestNValid((long)n) && this.endOffset >= 0) {
                this.sendOnError(SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                return;
            }
            this.endOffset = Math.min((int)Math.min(Integer.MAX_VALUE, FlowControlUtils.addWithOverflowProtection((long)this.endOffset, (long)n)), this.values.length);
            if (this.ignoreRequests) {
                return;
            }
            this.ignoreRequests = true;
            while (this.beginOffset < this.endOffset) {
                try {
                    this.subscriber.onNext(this.values[this.beginOffset]);
                }
                catch (Throwable cause) {
                    this.sendOnError(cause);
                    return;
                }
                ++this.beginOffset;
            }
            if (this.endOffset >= 0) {
                this.ignoreRequests = false;
            }
            if (this.beginOffset == this.values.length) {
                this.sendComplete();
            }
        }

        public void cancel() {
            this.endOffset = -1;
            this.beginOffset = -1;
            this.ignoreRequests = true;
        }

        private void sendOnError(Throwable cause) {
            this.cancel();
            try {
                this.subscriber.onError(cause);
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onError of Subscriber {}.", this.subscriber, (Object)t);
            }
        }

        private void sendComplete() {
            this.cancel();
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable t) {
                LOGGER.info("Ignoring exception from onComplete of Subscriber {}.", this.subscriber, (Object)t);
            }
        }
    }
}

